/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.maven.plugins.amps.codegen.prompter.common.component;

import com.atlassian.maven.plugins.amps.codegen.annotations.ModuleCreatorClass;
import com.atlassian.maven.plugins.amps.codegen.prompter.AbstractModulePrompter;
import com.atlassian.plugins.codegen.modules.PluginModuleLocation;
import com.atlassian.plugins.codegen.modules.common.component.ComponentModuleCreator;
import com.atlassian.plugins.codegen.modules.common.component.ComponentProperties;
import com.atlassian.plugins.codegen.util.ClassnameUtil;
import java.io.File;
import java.util.HashMap;
import java.util.Map;
import java.util.regex.Matcher;
import org.apache.commons.lang.StringUtils;
import org.codehaus.plexus.components.interactivity.Prompter;
import org.codehaus.plexus.components.interactivity.PrompterException;

@ModuleCreatorClass(value=ComponentModuleCreator.class)
public class ComponentModulePrompter
extends AbstractModulePrompter<ComponentProperties> {
    public ComponentModulePrompter(Prompter prompter) {
        super(prompter);
    }

    @Override
    public ComponentProperties promptForBasicProperties(PluginModuleLocation moduleLocation) throws PrompterException {
        String interfaceName = this.promptJavaClassname("Enter Interface name", "MYComponent");
        String interfacePackage = this.promptJavaPackagename("Enter Interface package", this.getDefaultBasePackage() + ".components");
        String className = this.promptJavaClassname("Enter Class name", interfaceName + "Impl");
        String packageName = this.promptJavaPackagename("Enter Package Name", interfacePackage);
        String fqClass = ClassnameUtil.fullyQualifiedName((String)packageName, (String)className);
        String fqInterface = ClassnameUtil.fullyQualifiedName((String)interfacePackage, (String)interfaceName);
        ComponentProperties props = new ComponentProperties(fqClass);
        props.setFullyQualifiedInterface(fqInterface);
        props.setGenerateClass(!this.javaFileExists(props.getClassId().getFullName(), moduleLocation));
        props.setGenerateInterface(!this.javaFileExists(props.getInterfaceId().getFullName(), moduleLocation));
        this.suppressExamplesPrompt();
        return props;
    }

    @Override
    public void promptForAdvancedProperties(ComponentProperties props, PluginModuleLocation moduleLocation) throws PrompterException {
        String alias;
        boolean createClass = props.generateClass();
        boolean createInterface = props.generateInterface();
        if (createInterface) {
            props.setGenerateInterface(this.promptForBoolean("Generate Module Interface?", "Y"));
        }
        if (createClass) {
            props.setGenerateClass(this.promptForBoolean("Generate Module Class?", "Y"));
        }
        if (StringUtils.isNotBlank((String)(alias = this.prompter.prompt("Alias (not required)")))) {
            props.setAlias(alias);
        }
        props.setPublic(this.promptForBoolean("Public access?", "N"));
        Map<String, String> serviceProps = this.promptForServiceProps();
        if (serviceProps.size() > 0) {
            props.setServiceProps(serviceProps);
        }
        props.setIncludeExamples(false);
    }

    private Map<String, String> promptForServiceProps() throws PrompterException {
        HashMap<String, String> props = new HashMap<String, String>();
        this.promptForServiceProp(props);
        return props;
    }

    private void promptForServiceProp(Map<String, String> props) throws PrompterException {
        StringBuffer addBuffer = new StringBuffer();
        if (props.size() > 0) {
            addBuffer.append("service-properties:\n");
            for (Map.Entry<String, String> entry : props.entrySet()) {
                addBuffer.append(entry.getKey()).append("->").append(entry.getValue()).append("\n");
            }
        }
        addBuffer.append("Add Service Property?");
        boolean addProp = this.promptForBoolean(addBuffer.toString(), "N");
        if (addProp) {
            String key = this.promptNotBlank("property key");
            String value = this.promptNotBlank("property value");
            props.put(key, value);
            this.promptForServiceProp(props);
        }
    }

    private boolean javaFileExists(String fqInterface, PluginModuleLocation moduleLocation) {
        File javaFile = new File(moduleLocation.getSourceDirectory(), fqInterface.replaceAll("\\.", Matcher.quoteReplacement(File.separator)) + ".java");
        return javaFile.exists();
    }
}

