/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bitbucket.ssh.event;

import com.atlassian.bitbucket.audit.AuditEntry;
import com.atlassian.bitbucket.audit.AuditEntryBuilder;
import com.atlassian.bitbucket.audit.AuditEntryConverter;
import com.atlassian.bitbucket.project.Project;
import com.atlassian.bitbucket.repository.Repository;
import com.atlassian.bitbucket.ssh.SshAccessKey;
import com.atlassian.bitbucket.ssh.SshKey;
import com.atlassian.bitbucket.ssh.event.SshAccessKeyEvent;
import com.atlassian.bitbucket.util.AuditUtils;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import java.util.Date;
import java.util.Map;
import javax.annotation.Nonnull;

public class SshAccessKeyEventConverter
implements AuditEntryConverter<SshAccessKeyEvent> {
    @Nonnull
    public AuditEntry convert(@Nonnull SshAccessKeyEvent event, @Nonnull AuditEntryBuilder builder) {
        SshAccessKey accessKey = (SshAccessKey)Preconditions.checkNotNull((Object)((SshAccessKeyEvent)((Object)Preconditions.checkNotNull((Object)((Object)event), (Object)"event"))).getAccessKey(), (Object)"event.accessKey");
        Map<String, Object> keyMap = SshAccessKeyEventConverter.createKeyMap(accessKey.getKey());
        ImmutableMap.Builder detailsBuilder = ImmutableMap.builder().put((Object)"key", keyMap).put((Object)"permission", (Object)accessKey.getPermission().name());
        Project project = null;
        Repository repository = null;
        if (accessKey.getResource() instanceof Project) {
            project = (Project)accessKey.getResource();
            detailsBuilder.put((Object)"project", SshAccessKeyEventConverter.createProjectMap(project));
        } else {
            repository = (Repository)accessKey.getResource();
            detailsBuilder.put((Object)"repository", SshAccessKeyEventConverter.createRepositoryMap(repository));
        }
        ImmutableMap details = detailsBuilder.build();
        try {
            return builder.action(((Object)((Object)event)).getClass()).timestamp(new Date()).details(AuditUtils.toJson((Object)details)).user(event.getUser()).project(project).repository(repository).target(AuditUtils.toJson(keyMap)).build();
        }
        catch (RuntimeException e) {
            throw new RuntimeException(String.format("Failed to convert map %s to JSON", details), e);
        }
    }

    private static Map<String, Object> createKeyMap(SshKey key) {
        ImmutableMap.Builder builder = ImmutableMap.builder().put((Object)"id", (Object)key.getId());
        if (key.getLabel() != null) {
            builder.put((Object)"label", (Object)key.getLabel());
        }
        return builder.build();
    }

    private static Map<String, Object> createRepositoryMap(Repository repository) {
        return ImmutableMap.builder().put((Object)"id", (Object)repository.getId()).put((Object)"slug", (Object)repository.getSlug()).put((Object)"project", SshAccessKeyEventConverter.createProjectMap(repository.getProject())).build();
    }

    private static Map<String, Object> createProjectMap(Project project) {
        return ImmutableMap.builder().put((Object)"id", (Object)project.getId()).put((Object)"key", (Object)project.getKey()).build();
    }
}

