package com.atlassian.cache;

import com.atlassian.annotations.PublicApi;

import javax.annotation.Nullable;

/**
 * A resettable reference event.
 * <p/>
 * NOTE: Although Cache Reference does not support {@code null} as a valid value we are using it in {@code getValue}
 * as a way to represent missing value. We have the following reasons for this:
 * <ul>
 *     <li>Firstly, some events inherently do not have value. For instance resetting does not have a value as the
 *     corresponding element was just removed from the cached reference</li>
 *     <li>Secondly, in some implementations the information for the value and/or old value is not available at all.</li>
 *     <li>Thirdly, the listener can be added as a valueless listener</li>
 * </ul>
 *
 * @since 2.4
 */
@PublicApi
public interface CachedReferenceEvent<V>
{
    /**
     * Returns cached reference value
     *
     * @return the value. For details why is this method marked as {@code Nullable} please refer to the
     * class level documentation
     */
    @Nullable
    V getValue();
}
