package com.atlassian.cache;

import javax.annotation.Nonnull;

import com.atlassian.annotations.PublicApi;

/**
 * A Resettable reference.
 *
 * @since 2.0
 */
@PublicApi
public interface CachedReference<V>
{
    /**
     * Get a value from the cache.
     *
     * @return the cached value
     */
    @Nonnull
    V get();

    /**
     * Resets (clears/invalidates) this reference.
     */
    void reset();

    /**
     * Adds a {@link CachedReferenceListener}
     * @param listener the listener
     * @param includeValues if the events sent to this listener will include old/new value. This can be used in cases
     * when the cost of finding these values is big (network sync) but the listener is not interested in the concrete
     * values for events its getting. The support for this parameter is optional and implementation dependent
     * @since 2.4
     */
    void addListener(@Nonnull CachedReferenceListener<V> listener, boolean includeValues);

    /**
     * Removes a {@link CachedReferenceListener}
     * @param listener the listener
     * @since 2.4
     */
    void removeListener(@Nonnull CachedReferenceListener<V> listener);
}
