package com.atlassian.cache.impl;

import com.atlassian.cache.CacheEntryListener;
import com.atlassian.util.concurrent.LazyReference;

public class LazyCacheEntryListenerSupport<K, V> implements CacheEntryListenerSupport<K, V>
{
    private final LazyReference<CacheEntryListenerSupport<K, V>> lazyListenerSupport =
            new LazyReference<CacheEntryListenerSupport<K, V>>()
            {
                @Override
                protected CacheEntryListenerSupport<K, V> create() throws Exception {
                    init();
                    return createDelegate();
                }
            };

    protected void init()
    {
    }

    protected CacheEntryListenerSupport<K, V> createDelegate()
    {
        return new DefaultCacheEntryListenerSupport<K, V>();
    }

    private CacheEntryListenerSupport<K, V> loadDelegate()
    {
        return lazyListenerSupport.get();
    }

    private CacheEntryListenerSupport<K, V> getDelegate()
    {
        if (lazyListenerSupport.isInitialized())
        {
            return lazyListenerSupport.get();
        }
        else
        {
            return CacheEntryListenerSupport.EMPTY;
        }
    }

    @Override
    public void add(CacheEntryListener<K, V> listener, boolean includeValues)
    {
        loadDelegate().add(listener, includeValues);
    }

    @Override
    public void remove(CacheEntryListener<K, V> listener)
    {
        getDelegate().remove(listener);
    }

    @Override
    public void notifyAdd(K key, V value)
    {
        getDelegate().notifyAdd(key, value);
    }

    @Override
    public void notifyEvict(K key, V oldValue)
    {
        getDelegate().notifyEvict(key, oldValue);
    }

    @Override
    public void notifyRemove(K key, V oldValue)
    {
        getDelegate().notifyRemove(key, oldValue);
    }

    @Override
    public void notifyUpdate(K key, V value, V oldValue)
    {
        getDelegate().notifyUpdate(key, value, oldValue);
    }
}
