package com.atlassian.cache.impl;

import com.atlassian.cache.CachedReferenceListener;
import com.atlassian.util.concurrent.LazyReference;

public class LazyCachedReferenceListenerSupport<V> implements CachedReferenceListenerSupport<V>
{
    private final LazyReference<CachedReferenceListenerSupport<V>> lazyListenerSupport =
            new LazyReference<CachedReferenceListenerSupport<V>>()
            {
                @Override
                protected CachedReferenceListenerSupport<V> create() throws Exception
                {
                    init();
                    return createDelegate();
                }
            };

    protected void init()
    {
    }

    protected CachedReferenceListenerSupport<V> createDelegate()
    {
        return new DefaultCachedReferenceListenerSupport<V>();
    }

    private CachedReferenceListenerSupport<V> loadDelegate()
    {
        return lazyListenerSupport.get();
    }

    private CachedReferenceListenerSupport<V> getDelegate()
    {
        if (lazyListenerSupport.isInitialized())
        {
            return lazyListenerSupport.get();
        }
        else
        {
            return CachedReferenceListenerSupport.EMPTY;
        }
    }

    @Override
    public void add(CachedReferenceListener<V> listener, boolean includeValues)
    {
        loadDelegate().add(listener, includeValues);
    }

    @Override
    public void remove(CachedReferenceListener<V> listener)
    {
        getDelegate().remove(listener);
    }

    @Override
    public void notifyEvict(V oldValue)
    {
        getDelegate().notifyEvict(oldValue);
    }

    @Override
    public void notifySet(V value)
    {
        getDelegate().notifySet(value);
    }

    @Override
    public void notifyReset(V oldValue)
    {
        getDelegate().notifyReset(oldValue);
    }
}
