/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.api.model.retention;

import com.atlassian.annotations.ExperimentalApi;
import com.atlassian.confluence.api.model.retention.AgeUnit;
import java.io.Serializable;
import java.time.LocalDate;
import java.time.temporal.ChronoUnit;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import org.codehaus.jackson.annotate.JsonIgnoreProperties;
import org.codehaus.jackson.annotate.JsonProperty;

@ExperimentalApi
@JsonIgnoreProperties(ignoreUnknown=true)
public class RetentionRule
implements Serializable {
    private static final Integer MAX_AGE_LOWER_LIMIT = 1;
    private static final Integer MAX_AGE_UPPER_LIMIT = 10000;
    private static final Integer MAX_NUMBER_LOWER_LIMIT = 1;
    private static final Integer MAX_NUMBER_UPPER_LIMIT = 10000;
    private static final String DEFAULT_RULE_DESCRIPTION = "keepall";
    private static final String MULTIPLE_RULE_DESCRIPTION = "multiple";
    private static final String AGE_RULE_DESCRIPTION = "age";
    private static final String NUMBER_RULE_DESCRIPTION = "number";
    @JsonProperty
    private Integer maxAge;
    @JsonProperty
    private AgeUnit ageUnit;
    @JsonProperty
    private Integer maxNumberOfVersions;
    @JsonProperty
    private Boolean keepAll = true;

    public Integer getMaxAge() {
        return this.maxAge;
    }

    public void setMaxAge(Integer maxAge) {
        this.maxAge = maxAge;
    }

    public AgeUnit getAgeUnit() {
        return this.ageUnit;
    }

    public void setAgeUnit(AgeUnit ageUnit) {
        this.ageUnit = ageUnit;
    }

    public Integer getMaxNumberOfVersions() {
        return this.maxNumberOfVersions;
    }

    public void setMaxNumberOfVersions(Integer maxNumberOfVersions) {
        this.maxNumberOfVersions = maxNumberOfVersions;
    }

    public Boolean getKeepAll() {
        return this.keepAll;
    }

    public void setKeepAll(Boolean keepAll) {
        this.keepAll = keepAll;
    }

    public boolean hasVersionLimit() {
        return this.maxNumberOfVersions != null;
    }

    public boolean hasAgeLimit() {
        return this.maxAge != null && this.ageUnit != null;
    }

    public List<String> validate() {
        ArrayList<String> validations = new ArrayList<String>();
        if (!this.isValidMaxAge().booleanValue()) {
            validations.add(String.format("maxAge should be between than %s and %s", MAX_AGE_LOWER_LIMIT, MAX_AGE_UPPER_LIMIT));
        }
        if (!this.isValidMaxNumber().booleanValue()) {
            validations.add(String.format("maxNumberOfVersions should be between %s and %s", MAX_NUMBER_LOWER_LIMIT, MAX_NUMBER_UPPER_LIMIT));
        }
        if (!this.isValidAgeUnit().booleanValue()) {
            validations.add("ageUnit of DAY, MONTH or YEAR should be provided when maxAge specified");
        }
        if (this.getKeepAll().booleanValue() && (this.getMaxAge() != null || this.getMaxNumberOfVersions() != null)) {
            validations.add("maxAge and maxNumberOfVersions should be null when keepAll is true");
        }
        return validations;
    }

    public String formatRuleDescription() {
        if (this.keepAll.booleanValue()) {
            return DEFAULT_RULE_DESCRIPTION;
        }
        if (this.maxAge != null && this.maxNumberOfVersions != null) {
            return MULTIPLE_RULE_DESCRIPTION;
        }
        if (this.maxAge != null) {
            return AGE_RULE_DESCRIPTION;
        }
        if (this.maxNumberOfVersions != null) {
            return NUMBER_RULE_DESCRIPTION;
        }
        return DEFAULT_RULE_DESCRIPTION;
    }

    public LocalDate calculateMaxDate(LocalDate now) {
        return now.minus(this.maxAge.intValue(), ChronoUnit.valueOf(this.ageUnit.name()));
    }

    public boolean equals(Object other) {
        if (!(other instanceof RetentionRule)) {
            return false;
        }
        RetentionRule retentionRule = (RetentionRule)other;
        return Objects.equals(retentionRule.maxAge, this.maxAge) && Objects.equals(retentionRule.ageUnit, this.ageUnit) && Objects.equals(retentionRule.maxNumberOfVersions, this.maxNumberOfVersions) && Objects.equals(retentionRule.getKeepAll(), this.keepAll);
    }

    public int hashCode() {
        return Objects.hash(this.maxAge, this.ageUnit, this.maxNumberOfVersions, this.keepAll);
    }

    private Boolean isValidMaxAge() {
        if (this.maxAge == null) {
            return true;
        }
        return this.maxAge >= MAX_AGE_LOWER_LIMIT && this.maxAge <= MAX_AGE_UPPER_LIMIT;
    }

    private Boolean isValidMaxNumber() {
        if (this.maxNumberOfVersions == null) {
            return true;
        }
        return this.maxNumberOfVersions >= MAX_NUMBER_LOWER_LIMIT && this.maxNumberOfVersions <= MAX_NUMBER_UPPER_LIMIT;
    }

    private Boolean isValidAgeUnit() {
        return this.maxAge == null || this.ageUnit != null;
    }
}

