/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.crowd.audit;

import com.atlassian.crowd.audit.AuditLogAuthorType;
import com.atlassian.crowd.audit.AuditLogChangeset;
import com.atlassian.crowd.audit.AuditLogEntityType;
import com.atlassian.crowd.audit.AuditLogEntry;
import com.atlassian.crowd.audit.AuditLogEventType;
import com.atlassian.crowd.audit.ImmutableAuditLogEntry;
import java.time.Instant;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;

public class ImmutableAuditLogChangeset
implements AuditLogChangeset {
    private final Long id;
    private final Instant timestamp;
    private final AuditLogAuthorType authorType;
    private final Long authorId;
    private final String authorName;
    private final AuditLogEventType eventType;
    private final AuditLogEntityType entityType;
    private final Long entityId;
    private final String entityName;
    private final String ipAddress;
    private final String eventMessage;
    private final List<ImmutableAuditLogEntry> entries;

    public ImmutableAuditLogChangeset(Long id, Instant timestamp, AuditLogAuthorType authorType, Long authorId, String authorName, AuditLogEventType eventType, AuditLogEntityType entityType, Long entityId, String entityName, String ipAddress, String eventMessage, List<ImmutableAuditLogEntry> entries) {
        this.id = id;
        this.timestamp = timestamp;
        this.authorType = authorType;
        this.authorId = authorId;
        this.authorName = authorName;
        this.eventType = eventType;
        this.entityType = entityType;
        this.entityId = entityId;
        this.entityName = entityName;
        this.ipAddress = ipAddress;
        this.eventMessage = eventMessage;
        this.entries = entries;
    }

    @Override
    public Long getId() {
        return this.id;
    }

    @Override
    public Instant getTimestampInstant() {
        return this.timestamp;
    }

    @Override
    public AuditLogAuthorType getAuthorType() {
        return this.authorType;
    }

    @Override
    public Long getAuthorId() {
        return this.authorId;
    }

    @Override
    public String getAuthorName() {
        return this.authorName;
    }

    @Override
    public AuditLogEventType getEventType() {
        return this.eventType;
    }

    @Override
    public AuditLogEntityType getEntityType() {
        return this.entityType;
    }

    @Override
    public Long getEntityId() {
        return this.entityId;
    }

    @Override
    public String getEntityName() {
        return this.entityName;
    }

    @Override
    public String getIpAddress() {
        return this.ipAddress;
    }

    @Override
    public String getEventMessage() {
        return this.eventMessage;
    }

    public List<ImmutableAuditLogEntry> getEntries() {
        return this.entries;
    }

    public static class Builder {
        private Long id;
        private Instant timestamp;
        private AuditLogAuthorType authorType;
        private Long authorId;
        private String authorName;
        private AuditLogEventType eventType;
        private AuditLogEntityType entityType;
        private Long entityId;
        private String entityName;
        private String ipAddress;
        private String eventMessage;
        private List<ImmutableAuditLogEntry> entries = new ArrayList<ImmutableAuditLogEntry>();

        public Builder() {
        }

        public Builder(AuditLogChangeset changeset) {
            this.id = changeset.getId();
            this.timestamp = changeset.getTimestampInstant();
            this.authorType = changeset.getAuthorType();
            this.authorId = changeset.getAuthorId();
            this.authorName = changeset.getAuthorName();
            this.eventType = changeset.getEventType();
            this.entityType = changeset.getEntityType();
            this.entityId = changeset.getEntityId();
            this.entityName = changeset.getEntityName();
            this.ipAddress = changeset.getIpAddress();
            this.eventMessage = changeset.getEventMessage();
            this.entries = changeset.getEntries().stream().map(ImmutableAuditLogEntry.Builder::new).map(ImmutableAuditLogEntry.Builder::build).collect(Collectors.toList());
        }

        public Builder setId(Long id) {
            this.id = id;
            return this;
        }

        public Builder setTimestamp(Instant timestamp) {
            this.timestamp = timestamp;
            return this;
        }

        public Builder setTimestamp(Long timestamp) {
            this.timestamp = Instant.ofEpochMilli(timestamp);
            return this;
        }

        public Builder setAuthorType(AuditLogAuthorType authorType) {
            this.authorType = authorType;
            return this;
        }

        public Builder setAuthorId(Long authorId) {
            this.authorId = authorId;
            return this;
        }

        public Builder setAuthorName(String authorName) {
            this.authorName = authorName;
            return this;
        }

        public Builder setEventType(AuditLogEventType eventType) {
            this.eventType = eventType;
            return this;
        }

        public Builder setEntityType(AuditLogEntityType entityType) {
            this.entityType = entityType;
            return this;
        }

        public Builder setEntityId(Long entityId) {
            this.entityId = entityId;
            return this;
        }

        public Builder setEntityName(String entityName) {
            this.entityName = entityName;
            return this;
        }

        public Builder setIpAddress(String ipAddress) {
            this.ipAddress = ipAddress;
            return this;
        }

        public Builder setEventMessage(String eventMessage) {
            this.eventMessage = eventMessage;
            return this;
        }

        public Builder setEntries(List<ImmutableAuditLogEntry> entries) {
            this.entries = entries;
            return this;
        }

        public Builder addEntry(AuditLogEntry entry) {
            this.entries.add(new ImmutableAuditLogEntry.Builder(entry).build());
            return this;
        }

        public Builder addEntry(ImmutableAuditLogEntry entry) {
            this.entries.add(entry);
            return this;
        }

        public ImmutableAuditLogChangeset build() {
            if (this.entries == null) {
                this.entries = Collections.emptyList();
            }
            return new ImmutableAuditLogChangeset(this.id, this.timestamp, this.authorType, this.authorId, this.authorName, this.eventType, this.entityType, this.entityId, this.entityName, this.ipAddress, this.eventMessage, this.entries);
        }
    }
}

