/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.crowd.manager.application;

import com.atlassian.annotations.ExperimentalApi;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.NoSuchElementException;

@ExperimentalApi
public interface PagedSearcher<T> {
    public List<T> fetchNextBatch(int var1);

    default public Iterable<T> asIterable(final int batchSize) {
        return () -> new Iterator<T>(){
            private Iterator<T> current = Collections.emptyIterator();
            private T nextElement;

            @Override
            public boolean hasNext() {
                if (this.nextElement != null) {
                    return true;
                }
                if (!this.current.hasNext()) {
                    this.current = PagedSearcher.this.fetchNextBatch(batchSize).iterator();
                }
                if (this.current.hasNext()) {
                    this.nextElement = this.current.next();
                    return true;
                }
                return false;
            }

            @Override
            public T next() {
                if (this.hasNext()) {
                    Object result = this.nextElement;
                    this.nextElement = null;
                    return result;
                }
                throw new NoSuchElementException();
            }
        };
    }
}

