/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.crowd.model.application;

import com.atlassian.crowd.embedded.api.Directory;
import com.atlassian.crowd.embedded.api.OperationType;
import com.atlassian.crowd.model.application.ApplicationDirectoryMapping;
import com.atlassian.crowd.model.directory.ImmutableDirectory;
import java.util.Collections;
import java.util.HashSet;
import java.util.Objects;
import java.util.Set;

public class ImmutableApplicationDirectoryMapping
implements ApplicationDirectoryMapping {
    private final ImmutableDirectory directory;
    private final boolean allowAllToAuthenticate;
    private final Set<String> authorisedGroupNames;
    private final Set<OperationType> allowedOperations;

    private ImmutableApplicationDirectoryMapping(Builder builder) {
        this.directory = builder.directory;
        this.allowAllToAuthenticate = builder.allowAllToAuthenticate;
        this.authorisedGroupNames = builder.authorisedGroupNames;
        this.allowedOperations = builder.allowedOperations;
    }

    public static Builder builder() {
        return new Builder();
    }

    public static Builder builder(ApplicationDirectoryMapping applicationDirectoryMapping) {
        return new Builder(Objects.requireNonNull(applicationDirectoryMapping));
    }

    public static ImmutableApplicationDirectoryMapping from(ApplicationDirectoryMapping applicationDirectoryMapping) {
        return applicationDirectoryMapping instanceof ImmutableApplicationDirectoryMapping ? (ImmutableApplicationDirectoryMapping)applicationDirectoryMapping : ImmutableApplicationDirectoryMapping.builder(applicationDirectoryMapping).build();
    }

    public Directory getDirectory() {
        return this.directory;
    }

    public boolean isAllowAllToAuthenticate() {
        return this.allowAllToAuthenticate;
    }

    public Set<String> getAuthorisedGroupNames() {
        return this.authorisedGroupNames;
    }

    public Set<OperationType> getAllowedOperations() {
        return this.allowedOperations;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ImmutableApplicationDirectoryMapping that = (ImmutableApplicationDirectoryMapping)o;
        return this.allowAllToAuthenticate == that.allowAllToAuthenticate && Objects.equals(this.directory, that.directory) && Objects.equals(this.authorisedGroupNames, that.authorisedGroupNames) && Objects.equals(this.allowedOperations, that.allowedOperations);
    }

    public int hashCode() {
        return Objects.hash(this.directory, this.allowAllToAuthenticate, this.authorisedGroupNames, this.allowedOperations);
    }

    public String toString() {
        return String.format("ImmutableApplicationDirectoryMapping{directory=%s, allowAllToAuthenticate=%s, authorisedGroupNames=%s, allowedOperations=%s}", this.directory, this.allowAllToAuthenticate, this.authorisedGroupNames, this.allowedOperations);
    }

    public static final class Builder {
        private ImmutableDirectory directory;
        private boolean allowAllToAuthenticate;
        private Set<String> authorisedGroupNames = Collections.emptySet();
        private Set<OperationType> allowedOperations = Collections.emptySet();

        private Builder() {
        }

        private Builder(ApplicationDirectoryMapping mapping) {
            this.setDirectory(mapping.getDirectory());
            this.setAllowedOperations(mapping.getAllowedOperations());
            this.setAuthorisedGroupNames(mapping.getAuthorisedGroupNames());
            this.setAllowAllToAuthenticate(mapping.isAllowAllToAuthenticate());
        }

        public Builder setDirectory(Directory directory) {
            this.directory = ImmutableDirectory.from(directory);
            return this;
        }

        public Builder setAllowAllToAuthenticate(boolean allowAllToAuthenticate) {
            this.allowAllToAuthenticate = allowAllToAuthenticate;
            return this;
        }

        public Builder setAuthorisedGroupNames(Set<String> authorisedGroupNames) {
            this.authorisedGroupNames = Collections.unmodifiableSet(new HashSet<String>(authorisedGroupNames));
            return this;
        }

        public Builder setAllowedOperations(Set<OperationType> allowedOperations) {
            this.allowedOperations = Collections.unmodifiableSet(new HashSet<OperationType>(allowedOperations));
            return this;
        }

        public ImmutableApplicationDirectoryMapping build() {
            return new ImmutableApplicationDirectoryMapping(this);
        }
    }
}

