package com.atlassian.crowd.model.group;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableSet;

import java.util.Objects;
import java.util.Set;

public final class ImmutableMembership implements Membership {
    private final String groupName;
    private final Set<String> userNames;
    private final Set<String> childGroupNames;

    public ImmutableMembership(String groupName, Iterable<String> userNames, Iterable<String> childGroupNames) {
        this.groupName = Preconditions.checkNotNull(groupName);
        this.childGroupNames = ImmutableSet.copyOf(childGroupNames);
        this.userNames = ImmutableSet.copyOf(userNames);
    }

    @Override
    public String getGroupName() {
        return groupName;
    }

    @Override
    public Set<String> getUserNames() {
        return userNames;
    }

    @Override
    public Set<String> getChildGroupNames() {
        return childGroupNames;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;
        ImmutableMembership that = (ImmutableMembership) o;
        return Objects.equals(groupName, that.groupName) &&
                Objects.equals(userNames, that.userNames) &&
                Objects.equals(childGroupNames, that.childGroupNames);
    }

    @Override
    public int hashCode() {
        return Objects.hash(groupName, userNames, childGroupNames);
    }

    @Override
    public String toString() {
        return "ImmutableMembership{" +
                "groupName='" + groupName + '\'' +
                ", userNames=" + userNames +
                ", childGroupNames=" + childGroupNames +
                '}';
    }
}
