package com.atlassian.crowd.integration.springsecurity;

import com.atlassian.crowd.model.authentication.ValidationFactor;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;

import java.io.Serializable;
import java.util.List;

/**
 * The authentication details for an AuthenticationToken.
 * <p>
 * This consists of:
 * <ol>
 * <li>validationFactors: collection of request validation factors like remote IP, user-agent, etc.</li>
 * </ol>
 */
public class CrowdSSOAuthenticationDetails implements Serializable {
    private final String applicationName;
    private final List<ValidationFactor> validationFactors;

    public CrowdSSOAuthenticationDetails(String applicationName, Iterable<ValidationFactor> validationFactors) {
        this.applicationName = Preconditions.checkNotNull(applicationName);
        this.validationFactors = ImmutableList.copyOf(validationFactors);
    }

    public String getApplicationName() {
        return applicationName;
    }

    public List<ValidationFactor> getValidationFactors() {
        return validationFactors;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;

        return validationFactors.equals(((CrowdSSOAuthenticationDetails) o).validationFactors);
    }

    @Override
    public int hashCode() {
        return validationFactors.hashCode();
    }
}
