package com.atlassian.crowd.integration.springsecurity;

import org.springframework.security.core.AuthenticationException;
import org.springframework.security.web.authentication.SimpleUrlAuthenticationFailureHandler;

import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import java.io.IOException;

public class UsernameStoringAuthenticationFailureHandler extends SimpleUrlAuthenticationFailureHandler {
    // Replaces UsernamePasswordAuthenticationFilter.SPRING_SECURITY_LAST_USERNAME_KEY, which was
    // removed in Spring Security 4
    public static final String LAST_USERNAME_KEY = "SPRING_SECURITY_LAST_USERNAME";
    private final String usernameParameter;

    public UsernameStoringAuthenticationFailureHandler(String usernameParameter) {
        this.usernameParameter = usernameParameter;
    }

    @Override
    public void onAuthenticationFailure(HttpServletRequest request, HttpServletResponse response,
                                        AuthenticationException exception) throws IOException, ServletException {
        storeUsername(request, request.getParameter(usernameParameter));
        super.onAuthenticationFailure(request, response, exception);
    }

    protected void storeUsername(HttpServletRequest request, String username) {
        if (username != null) {
            HttpSession session = request.getSession(false);
            if (session != null) {
                request.getSession().setAttribute(LAST_USERNAME_KEY, username);
            }
        }
    }
}
