/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.crowd.integration.springsecurity;

import com.atlassian.crowd.exception.ApplicationAccessDeniedException;
import com.atlassian.crowd.exception.ApplicationPermissionException;
import com.atlassian.crowd.exception.ExpiredCredentialException;
import com.atlassian.crowd.exception.InactiveAccountException;
import com.atlassian.crowd.exception.InvalidAuthenticationException;
import com.atlassian.crowd.exception.InvalidTokenException;
import com.atlassian.crowd.exception.OperationFailedException;
import com.atlassian.crowd.integration.springsecurity.CrowdAccessDeniedException;
import com.atlassian.crowd.integration.springsecurity.CrowdRememberMeAuthentication;
import com.atlassian.crowd.integration.springsecurity.CrowdSSOAuthenticationDetails;
import com.atlassian.crowd.integration.springsecurity.CrowdSSOAuthenticationToken;
import com.atlassian.crowd.integration.springsecurity.CrowdSSOTokenInvalidException;
import com.atlassian.crowd.integration.springsecurity.user.CrowdUserDetails;
import com.atlassian.crowd.model.authentication.ValidationFactor;
import com.atlassian.crowd.model.user.User;
import java.util.Collections;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.dao.DataAccessException;
import org.springframework.security.authentication.AbstractAuthenticationToken;
import org.springframework.security.authentication.AuthenticationProvider;
import org.springframework.security.authentication.AuthenticationServiceException;
import org.springframework.security.authentication.BadCredentialsException;
import org.springframework.security.authentication.CredentialsExpiredException;
import org.springframework.security.authentication.DisabledException;
import org.springframework.security.authentication.UsernamePasswordAuthenticationToken;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.AuthenticationException;
import org.springframework.security.core.userdetails.UserDetails;
import org.springframework.security.core.userdetails.UsernameNotFoundException;

public abstract class CrowdAuthenticationProvider
implements AuthenticationProvider {
    private static final Logger logger = LoggerFactory.getLogger(CrowdAuthenticationProvider.class);

    public Authentication authenticate(Authentication authentication) throws AuthenticationException {
        if (!this.supports(authentication.getClass())) {
            return null;
        }
        if (!this.supports((AbstractAuthenticationToken)authentication)) {
            return null;
        }
        Authentication authenticatedToken = null;
        if (authentication instanceof UsernamePasswordAuthenticationToken) {
            logger.debug("Processing a UsernamePasswordAuthenticationToken");
            authenticatedToken = this.authenticateUsernamePassword((UsernamePasswordAuthenticationToken)authentication);
        } else if (authentication instanceof CrowdSSOAuthenticationToken) {
            logger.debug("Processing a CrowdSSOAuthenticationToken");
            authenticatedToken = this.authenticateCrowdSSO((CrowdSSOAuthenticationToken)authentication);
        } else if (authentication instanceof CrowdRememberMeAuthentication) {
            logger.debug("Processing a CrowdRememberMeAuthentication");
            authenticatedToken = this.authenticateCrowdRememberedUsername((CrowdRememberMeAuthentication)authentication);
        }
        return authenticatedToken;
    }

    protected Authentication authenticateUsernamePassword(UsernamePasswordAuthenticationToken passwordToken) throws AuthenticationException {
        Object authenticatedToken;
        if (passwordToken.getPrincipal() == null || StringUtils.isEmpty((CharSequence)passwordToken.getPrincipal().toString())) {
            throw new BadCredentialsException("UsernamePasswordAuthenticationToken contains empty username");
        }
        if (passwordToken.getCredentials() == null || StringUtils.isEmpty((CharSequence)passwordToken.getCredentials().toString())) {
            throw new BadCredentialsException("UsernamePasswordAuthenticationToken contains empty password");
        }
        try {
            if (passwordToken.getDetails() != null && passwordToken.getDetails() instanceof CrowdSSOAuthenticationDetails) {
                CrowdSSOAuthenticationDetails details = (CrowdSSOAuthenticationDetails)passwordToken.getDetails();
                String crowdTokenString = this.authenticate(passwordToken.getPrincipal().toString(), passwordToken.getCredentials().toString(), details.getValidationFactors());
                CrowdUserDetails userDetails = this.loadUserByToken(crowdTokenString);
                authenticatedToken = new CrowdSSOAuthenticationToken((UserDetails)userDetails, crowdTokenString, userDetails.getAuthorities());
            } else {
                this.authenticate(passwordToken.getPrincipal().toString(), passwordToken.getCredentials().toString(), Collections.emptyList());
                CrowdUserDetails userDetails = this.loadUserByUsername(passwordToken.getPrincipal().toString());
                authenticatedToken = new UsernamePasswordAuthenticationToken((Object)userDetails, passwordToken.getCredentials(), userDetails.getAuthorities());
            }
        }
        catch (Exception e) {
            throw this.translateException(e);
        }
        return authenticatedToken;
    }

    protected abstract boolean isAuthenticated(String var1, List<ValidationFactor> var2) throws OperationFailedException, InvalidAuthenticationException, ApplicationPermissionException;

    protected abstract String authenticate(String var1, String var2, List<ValidationFactor> var3) throws InactiveAccountException, ExpiredCredentialException, ApplicationPermissionException, InvalidAuthenticationException, OperationFailedException, ApplicationAccessDeniedException;

    protected abstract String authenticateWithoutPassword(String var1, List<ValidationFactor> var2) throws InactiveAccountException, ExpiredCredentialException, ApplicationPermissionException, InvalidAuthenticationException, OperationFailedException, ApplicationAccessDeniedException;

    protected abstract CrowdUserDetails loadUserByUsername(String var1) throws UsernameNotFoundException, DataAccessException;

    protected abstract CrowdUserDetails loadUserByToken(String var1) throws CrowdSSOTokenInvalidException, DataAccessException;

    protected Authentication authenticateCrowdSSO(CrowdSSOAuthenticationToken ssoToken) throws AuthenticationException {
        CrowdSSOAuthenticationToken authenticatedToken;
        if (ssoToken.getCredentials() == null || StringUtils.isEmpty((CharSequence)ssoToken.getCredentials().toString())) {
            throw new BadCredentialsException("CrowdSSOAuthenticationToken contains empty token credential");
        }
        if (ssoToken.getDetails() == null || !(ssoToken.getDetails() instanceof CrowdSSOAuthenticationDetails)) {
            throw new BadCredentialsException("CrowdSSOAuthenticationToken does not contain any validation factors");
        }
        String crowdTokenString = ssoToken.getCredentials().toString();
        CrowdSSOAuthenticationDetails details = (CrowdSSOAuthenticationDetails)ssoToken.getDetails();
        try {
            if (!this.isAuthenticated(crowdTokenString, details.getValidationFactors())) {
                throw new CrowdSSOTokenInvalidException("Crowd SSO token is invalid");
            }
            CrowdUserDetails userDetails = this.loadUserByToken(crowdTokenString);
            authenticatedToken = new CrowdSSOAuthenticationToken((UserDetails)userDetails, crowdTokenString, userDetails.getAuthorities());
        }
        catch (Exception e) {
            throw this.translateException(e);
        }
        return authenticatedToken;
    }

    protected Authentication authenticateCrowdRememberedUsername(CrowdRememberMeAuthentication rememberMeAuthentication) throws AuthenticationException {
        User principal = (User)rememberMeAuthentication.getPrincipal();
        if (principal == null || StringUtils.isBlank((CharSequence)principal.getName())) {
            throw new BadCredentialsException("CrowdRememberMeAuthentication contains empty principal");
        }
        try {
            CrowdUserDetails userDetails = this.loadUserByUsername(principal.getName());
            if (userDetails.getRemotePrincipal().getDirectoryId() != principal.getDirectoryId()) {
                throw new BadCredentialsException("Cannot extend user session due to invalid remember-me token");
            }
            CrowdSSOAuthenticationDetails crowdSSODetails = (CrowdSSOAuthenticationDetails)rememberMeAuthentication.getDetails();
            String crowdTokenString = this.authenticateWithoutPassword(principal.getName(), crowdSSODetails.getValidationFactors());
            return new CrowdSSOAuthenticationToken((UserDetails)userDetails, crowdTokenString, userDetails.getAuthorities());
        }
        catch (Exception e) {
            throw this.translateException(e);
        }
    }

    protected AuthenticationException translateException(Exception e) {
        if (e instanceof AuthenticationException) {
            return (AuthenticationException)e;
        }
        if (e instanceof ApplicationAccessDeniedException) {
            return new CrowdAccessDeniedException("User does not have access to application.");
        }
        if (e instanceof ExpiredCredentialException) {
            return new CredentialsExpiredException(e.getMessage());
        }
        if (e instanceof InvalidAuthenticationException || e instanceof InvalidTokenException) {
            return new BadCredentialsException(e.getMessage(), (Throwable)e);
        }
        if (e instanceof InactiveAccountException) {
            return new DisabledException(e.getMessage(), (Throwable)e);
        }
        return new AuthenticationServiceException(e.getMessage(), (Throwable)e);
    }

    public boolean supports(Class<?> authentication) {
        return UsernamePasswordAuthenticationToken.class.isAssignableFrom(authentication) || CrowdSSOAuthenticationToken.class.isAssignableFrom(authentication) || CrowdRememberMeAuthentication.class.isAssignableFrom(authentication);
    }

    public boolean supports(AbstractAuthenticationToken authenticationToken) {
        return authenticationToken.getDetails() == null || authenticationToken.getDetails() instanceof CrowdSSOAuthenticationDetails;
    }
}

