package com.atlassian.crowd.validator;

/**
 * Represents a subset of context that should be used for Directory Validation
 *
 * @since 3.2.0
 */
public enum DirectoryValidationContext {
    /**
     * Context representing that all relevant attributes must be validated
     */
    DEFAULT,

    /**
     * Context representing that attributes related to connection must be validated
     */
    CONNECTION,

    /**
     * Context representing that attributes related to connector must be validated
     */
    CONNECTOR_ATTRIBUTES,

    /**
     * Context representing that attributes related to user configuration of LDAP must be validated
     */
    USER_CONFIGURATION,

    /**
     * Context representing that attributes related to group configuration of LDAP must be validated
     */
    GROUP_CONFIGURATION,

    /**
     * Context representing that attributes related to user search test in LDAP must be validated
     */
    USER_SEARCH,

    /**
     * Context representing that attributes related to group search test in LDAP must be validated
     */
    GROUP_SEARCH
}
