/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.crowd.embedded.api;

import com.atlassian.crowd.embedded.api.PasswordCredential;
import com.atlassian.crowd.embedded.api.User;
import java.util.Objects;

public final class ValidatePasswordRequest {
    private final PasswordCredential password;
    private final User user;

    public ValidatePasswordRequest(PasswordCredential password, User user) {
        Objects.requireNonNull(password, "password");
        Objects.requireNonNull(user, "user");
        if (password.isEncryptedCredential()) {
            throw new IllegalArgumentException("password must not be encrypted");
        }
        this.password = password;
        this.user = user;
    }

    public PasswordCredential getPassword() {
        return this.password;
    }

    public User getUser() {
        return this.user;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ValidatePasswordRequest that = (ValidatePasswordRequest)o;
        if (!this.password.equals(that.password)) {
            return false;
        }
        return this.user.equals(that.user);
    }

    public int hashCode() {
        int result = this.password.hashCode();
        result = 31 * result + this.user.hashCode();
        return result;
    }

    public String toString() {
        return "ValidatePasswordRequest{password=" + String.valueOf(this.password) + ", user=" + String.valueOf(this.user) + "}";
    }
}

