/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.crowd.embedded.impl;

import com.atlassian.crowd.embedded.impl.IdentifierUtils;
import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import java.util.stream.Collectors;

public class IdentifierSet
extends HashSet<String> {
    public IdentifierSet() {
    }

    public IdentifierSet(Collection<? extends String> c) {
        super(IdentifierSet.lowercase(c));
    }

    public IdentifierSet(int initialCapacity, float loadFactor) {
        super(initialCapacity, loadFactor);
    }

    public IdentifierSet(int initialCapacity) {
        super(initialCapacity);
    }

    @Override
    public boolean removeAll(Collection<?> collection) {
        return super.removeAll(IdentifierSet.lowercase(collection));
    }

    @Override
    public boolean contains(Object object) {
        return super.contains(IdentifierSet.lowercase(object));
    }

    @Override
    public boolean add(String element) {
        return super.add(IdentifierUtils.toLowerCase(element));
    }

    @Override
    public boolean remove(Object object) {
        return super.remove(IdentifierSet.lowercase(object));
    }

    @Override
    public boolean containsAll(Collection<?> collection) {
        return super.containsAll(IdentifierSet.lowercase(collection));
    }

    @Override
    public boolean addAll(Collection<? extends String> strings) {
        return super.addAll(IdentifierSet.lowercase(strings));
    }

    @Override
    public boolean retainAll(Collection<?> collection) {
        return super.retainAll(IdentifierSet.lowercase(collection));
    }

    public static IdentifierSet difference(Collection<String> set1, Collection<String> set2) {
        IdentifierSet result = new IdentifierSet((Collection<? extends String>)set1);
        result.removeAll(set2);
        return result;
    }

    public static Set<String> differenceWithOriginalCasing(Collection<String> set1, Collection<String> set2) {
        return set1.stream().filter(IdentifierUtils.containsIdentifierPredicate(set2).negate()).collect(Collectors.toSet());
    }

    public static IdentifierSet intersection(Collection<String> set1, Collection<String> set2) {
        boolean firstSmaller = set1.size() < set2.size();
        IdentifierSet smaller = new IdentifierSet((Collection<? extends String>)(firstSmaller ? set1 : set2));
        smaller.retainAll(firstSmaller ? set2 : set1);
        return smaller;
    }

    private static <T> T lowercase(T element) {
        return (T)(element instanceof String ? IdentifierUtils.toLowerCase((String)element) : element);
    }

    private static Collection<?> lowercase(Collection<?> collection) {
        if (collection instanceof IdentifierSet) {
            return collection;
        }
        return collection.stream().map(IdentifierSet::lowercase).collect(Collectors.toSet());
    }
}

