/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.rest.client;

import com.google.common.base.Joiner;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;

public class RestClientException
extends RuntimeException {
    private final Collection<String> errorMessages;

    public RestClientException(Throwable cause) {
        super(cause);
        this.errorMessages = Collections.emptyList();
    }

    public RestClientException(String errorMessage, Throwable cause) {
        super(errorMessage, cause);
        this.errorMessages = Arrays.asList(errorMessage);
    }

    public RestClientException(Collection<String> errorMessages, Throwable cause) {
        super(Joiner.on((String)"\n").join(errorMessages), cause);
        this.errorMessages = new ArrayList<String>(errorMessages);
    }

    public RestClientException(Collection<String> errorMessages) {
        super(Joiner.on((String)"\n").join(errorMessages));
        this.errorMessages = new ArrayList<String>(errorMessages);
    }

    public Iterable<String> getErrorMessages() {
        return this.errorMessages;
    }
}

