/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.application;

import com.atlassian.application.api.Application;
import com.atlassian.application.api.ApplicationAccess;
import com.atlassian.application.api.ApplicationKey;
import com.atlassian.fugue.Option;
import com.atlassian.sal.api.license.SingleProductLicenseDetailsView;
import com.google.common.base.Supplier;
import java.net.URI;
import java.util.Date;
import org.joda.time.DateTime;

public class MockApplication
implements Application {
    private final ApplicationKey key;
    private DateTime buildDate = DateTime.now();

    public MockApplication(ApplicationKey key) {
        this.key = key;
    }

    public MockApplication(String key) {
        this(ApplicationKey.valueOf((String)key));
    }

    public ApplicationKey getKey() {
        return this.key;
    }

    public String getName() {
        return String.format("%s-name", this.key.value());
    }

    public String getDescription() {
        return String.format("%s-description", this.key.value());
    }

    public String getVersion() {
        return String.format("%s-version", this.key);
    }

    public String getUserCountDescription(Option<Integer> count) {
        Supplier unlimited = () -> String.format("Unlimited %s users", this.key);
        return (String)count.map(c -> String.format("%d %s users", c, this.key)).getOrElse(unlimited);
    }

    public Option<URI> getConfigurationURI() {
        return Option.none();
    }

    public Option<URI> getPostInstallURI() {
        return Option.none();
    }

    public Option<URI> getPostUpdateURI() {
        return Option.none();
    }

    public Option<URI> getProductHelpServerSpaceURI() {
        return Option.none();
    }

    public Option<URI> getProductHelpCloudSpaceURI() {
        return Option.none();
    }

    public DateTime buildDate() {
        return this.buildDate;
    }

    public Option<SingleProductLicenseDetailsView> getLicense() {
        return Option.none();
    }

    public ApplicationAccess getAccess() {
        throw new UnsupportedOperationException("Not implemented");
    }

    public String getDefaultGroup() {
        return this.key.value() + "-group";
    }

    public void clearConfiguration() {
        throw new UnsupportedOperationException("Not implemented");
    }

    public MockApplication buildDate(Date date) {
        this.buildDate = new DateTime((Object)date);
        return this;
    }
}

