/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.application;

import com.atlassian.application.api.Application;
import com.atlassian.application.api.ApplicationAccess;
import com.atlassian.application.api.ApplicationKey;
import com.atlassian.application.api.ApplicationManager;
import com.atlassian.application.api.PlatformApplication;
import com.atlassian.fugue.Option;
import com.atlassian.jira.application.MockApplication;
import com.atlassian.jira.application.MockPlatformApplication;
import com.google.common.collect.Iterables;
import com.google.common.collect.Maps;
import java.util.Map;

public class MockApplicationManager
implements ApplicationManager {
    private Option<PlatformApplication> platformApplication = Option.some((Object)new MockPlatformApplication("platform"));
    private Map<ApplicationKey, Application> applications = Maps.newHashMap();

    public PlatformApplication getPlatform() {
        return (PlatformApplication)this.platformApplication.getOrThrow(() -> new IllegalStateException("No PlatformApplication available."));
    }

    public Iterable<Application> getApplications() {
        return Iterables.concat(this.platformApplication, this.applications.values());
    }

    public Option<Application> getApplication(ApplicationKey key) {
        Application application = this.applications.get(key);
        if (application == null) {
            if (this.platformApplication.isDefined() && ((PlatformApplication)this.platformApplication.get()).getKey().equals((Object)key)) {
                return this.platformApplication.map(Application.class::cast);
            }
            return Option.none();
        }
        return Option.some((Object)application);
    }

    public <A extends Application> Option<A> getApplication(ApplicationKey key, Class<A> type) {
        return this.getApplication(key).filter(type::isInstance).map(type::cast);
    }

    public Option<ApplicationAccess> getAccess(ApplicationKey key) {
        return this.getApplication(key).map(Application::getAccess);
    }

    public MockApplication addApplication(ApplicationKey key) {
        MockApplication application = new MockApplication(key);
        this.applications.put(key, application);
        return application;
    }

    public void removeApplication(ApplicationKey key) {
        this.applications.remove(key);
    }
}

