/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.application;

import com.atlassian.application.api.ApplicationKey;
import com.atlassian.fugue.Option;
import com.atlassian.jira.application.ApplicationRoleDefinitions;
import com.atlassian.jira.application.MockApplicationRoleDefinition;
import com.google.common.collect.Maps;
import java.util.Map;
import javax.annotation.Nonnull;
import javax.annotation.ParametersAreNonnullByDefault;

@ParametersAreNonnullByDefault
public class MockApplicationRoleDefinitions
implements ApplicationRoleDefinitions {
    private Map<ApplicationKey, ApplicationRoleDefinitions.ApplicationRoleDefinition> defined = Maps.newHashMap();
    private Map<ApplicationKey, ApplicationRoleDefinitions.ApplicationRoleDefinition> licensed = Maps.newHashMap();

    @Nonnull
    public Iterable<ApplicationRoleDefinitions.ApplicationRoleDefinition> getDefined() {
        return this.defined.values();
    }

    @Nonnull
    public Option<ApplicationRoleDefinitions.ApplicationRoleDefinition> getDefined(ApplicationKey key) {
        return Option.option((Object)this.defined.get(key));
    }

    public boolean isDefined(ApplicationKey key) {
        return this.getDefined(key).isDefined();
    }

    @Nonnull
    public Iterable<ApplicationRoleDefinitions.ApplicationRoleDefinition> getLicensed() {
        return this.licensed.values();
    }

    public Option<ApplicationRoleDefinitions.ApplicationRoleDefinition> getLicensed(ApplicationKey key) {
        return Option.option((Object)this.licensed.get(key));
    }

    public boolean isLicensed(ApplicationKey key) {
        return this.getLicensed(key).isDefined();
    }

    public void addDefined(ApplicationRoleDefinitions.ApplicationRoleDefinition definition) {
        this.defined.put(definition.key(), definition);
    }

    public MockApplicationRoleDefinition addDefined(String key, String name) {
        MockApplicationRoleDefinition definition = new MockApplicationRoleDefinition(key, name);
        this.addDefined(definition);
        return definition;
    }

    public void addLicensed(ApplicationRoleDefinitions.ApplicationRoleDefinition definition) {
        this.licensed.put(definition.key(), definition);
    }

    public MockApplicationRoleDefinition addLicensed(String key, String name) {
        MockApplicationRoleDefinition definition = new MockApplicationRoleDefinition(key, name);
        this.licensed.put(definition.key(), definition);
        return definition;
    }

    public void removeDefinition(ApplicationKey key) {
        this.defined.remove(key);
    }

    public void removeLicensed(ApplicationKey key) {
        this.licensed.remove(key);
    }

    public MockApplicationRoleDefinitions removeDefinition(ApplicationRoleDefinitions.ApplicationRoleDefinition def) {
        this.defined.remove(def.key());
        return this;
    }

    public MockApplicationRoleDefinitions removeLicensed(ApplicationRoleDefinitions.ApplicationRoleDefinition def) {
        this.licensed.remove(def.key());
        return this;
    }
}

