/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.cache;

import com.atlassian.cache.CacheManager;
import com.atlassian.cache.CacheSettings;
import com.atlassian.cache.memory.MemoryCacheManager;
import com.atlassian.jira.cache.CacheAdapter;
import com.atlassian.jira.cache.SingleValueLocalCache;
import com.atlassian.jira.cache.SwitchingCacheFactory;
import com.atlassian.jira.cache.SwitchingCacheFactoryImpl;
import com.atlassian.jira.cache.vcache.MockVCacheFactory;
import com.atlassian.jira.config.InstanceFeatureManager;
import com.atlassian.vcache.VCacheFactory;
import java.util.Optional;
import java.util.function.Supplier;
import org.mockito.Matchers;
import org.mockito.Mockito;

public class MockSwitchingCacheFactory
implements SwitchingCacheFactory {
    final SwitchingCacheFactory delegate;

    public MockSwitchingCacheFactory() {
        this(false);
    }

    public MockSwitchingCacheFactory(boolean requestCacheEnabled) {
        this(MockSwitchingCacheFactory.createFeatureManager(requestCacheEnabled));
    }

    public MockSwitchingCacheFactory(InstanceFeatureManager featureManager) {
        this(featureManager, new MockVCacheFactory(), (CacheManager)new MemoryCacheManager());
    }

    public MockSwitchingCacheFactory(InstanceFeatureManager featureManager, VCacheFactory vCacheFactory, CacheManager cacheManager) {
        this.delegate = new SwitchingCacheFactoryImpl(featureManager, vCacheFactory, cacheManager);
    }

    public <K, V> CacheAdapter<K, V> buildSwitchingRequestCache(String cacheName, Optional<CacheSettings> cacheSettings, String darkFeatureKey) {
        return this.delegate.buildSwitchingRequestCache(cacheName, cacheSettings, darkFeatureKey);
    }

    public <V> SingleValueLocalCache<V> buildSwitchingRequestCache(String cacheName, Supplier<V> supplier, String darkFeatureKey) {
        return this.delegate.buildSwitchingRequestCache(cacheName, supplier, darkFeatureKey);
    }

    private static InstanceFeatureManager createFeatureManager(boolean requestCacheEnabled) {
        InstanceFeatureManager featureManager = (InstanceFeatureManager)Mockito.mock(InstanceFeatureManager.class);
        Mockito.when((Object)featureManager.isInstanceFeatureEnabled(Matchers.anyString())).thenReturn((Object)requestCacheEnabled);
        return featureManager;
    }
}

