/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.cache.vcache;

import com.atlassian.vcache.CasIdentifier;
import com.atlassian.vcache.DirectExternalCache;
import com.atlassian.vcache.ExternalCacheSettings;
import com.atlassian.vcache.IdentifiedValue;
import com.atlassian.vcache.JvmCache;
import com.atlassian.vcache.JvmCacheSettingsBuilder;
import com.atlassian.vcache.Marshaller;
import com.atlassian.vcache.MarshallerException;
import com.atlassian.vcache.PutPolicy;
import com.atlassian.vcache.StableReadExternalCache;
import com.atlassian.vcache.internal.core.service.GuavaJvmCache;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.function.Function;
import java.util.function.Supplier;
import javax.annotation.Nonnull;
import javax.annotation.ParametersAreNonnullByDefault;

@ParametersAreNonnullByDefault
public class MockExternalCache<T>
implements DirectExternalCache<T>,
StableReadExternalCache<T> {
    private final String name;
    private final Marshaller<T> marshaller;
    private final JvmCache<String, byte[]> internalCache;

    public MockExternalCache(String name, Marshaller<T> marshaller, ExternalCacheSettings settings) {
        this.name = name;
        this.marshaller = marshaller;
        JvmCacheSettingsBuilder jvmCacheSettingsBuilder = new JvmCacheSettingsBuilder();
        settings.getDefaultTtl().ifPresent(arg_0 -> ((JvmCacheSettingsBuilder)jvmCacheSettingsBuilder).defaultTtl(arg_0));
        jvmCacheSettingsBuilder.maxEntries(settings.getEntryCountHint().orElse(Integer.MAX_VALUE).intValue());
        this.internalCache = new GuavaJvmCache(name + "-internal", jvmCacheSettingsBuilder.build());
    }

    @Nonnull
    public CompletionStage<Optional<IdentifiedValue<T>>> getIdentified(String s) {
        throw new UnsupportedOperationException("Not implemented");
    }

    @Nonnull
    public CompletionStage<Map<String, Optional<IdentifiedValue<T>>>> getBulkIdentified(Iterable<String> iterable) {
        throw new UnsupportedOperationException("Not implemented");
    }

    @Nonnull
    public CompletionStage<Boolean> removeIf(String s, CasIdentifier casIdentifier) {
        throw new UnsupportedOperationException("Not implemented");
    }

    @Nonnull
    public CompletionStage<Boolean> replaceIf(String s, CasIdentifier casIdentifier, T t) {
        throw new UnsupportedOperationException("Not implemented");
    }

    @Nonnull
    public CompletionStage<Optional<T>> get(String key) {
        return CompletableFuture.completedFuture(this.internalCache.get((Object)key).map(this::unmarshall));
    }

    @Nonnull
    public CompletionStage<T> get(String key, Supplier<T> supplier) {
        byte[] raw = (byte[])this.internalCache.get((Object)key, () -> this.marshall(supplier.get()));
        return CompletableFuture.completedFuture(this.unmarshall(raw));
    }

    @Nonnull
    public CompletionStage<Map<String, Optional<T>>> getBulk(Iterable<String> iterable) {
        throw new UnsupportedOperationException("Not implemented");
    }

    @Nonnull
    public CompletionStage<Map<String, T>> getBulk(Function<Set<String>, Map<String, T>> function, Iterable<String> iterable) {
        throw new UnsupportedOperationException("Not implemented");
    }

    @Nonnull
    public CompletionStage<Boolean> put(String key, T value, PutPolicy putPolicy) {
        switch (putPolicy) {
            case ADD_ONLY: {
                return CompletableFuture.completedFuture(!this.internalCache.putIfAbsent((Object)key, (Object)this.marshall(value)).isPresent());
            }
            case PUT_ALWAYS: {
                this.internalCache.put((Object)key, (Object)this.marshall(value));
                return CompletableFuture.completedFuture(true);
            }
            case REPLACE_ONLY: {
                boolean result = this.internalCache.get((Object)key).map(v -> {
                    this.internalCache.put((Object)key, (Object)this.marshall(value));
                    return true;
                }).orElseGet(() -> false);
                return CompletableFuture.completedFuture(result);
            }
        }
        throw new UnsupportedOperationException("Not implemented");
    }

    @Nonnull
    public CompletionStage<Void> remove(Iterable<String> iterable) {
        iterable.forEach(arg_0 -> this.internalCache.remove(arg_0));
        return CompletableFuture.completedFuture(null);
    }

    @Nonnull
    public CompletionStage<Void> removeAll() {
        this.internalCache.removeAll();
        return CompletableFuture.completedFuture(null);
    }

    @Nonnull
    public String getName() {
        return this.name;
    }

    private byte[] marshall(T object) {
        try {
            return this.marshaller.marshall(object);
        }
        catch (MarshallerException e) {
            throw new RuntimeException(e);
        }
    }

    private T unmarshall(byte[] raw) {
        try {
            return (T)this.marshaller.unmarshall(raw);
        }
        catch (MarshallerException e) {
            throw new RuntimeException(e);
        }
    }
}

