/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.cache.vcache;

import com.atlassian.jira.cache.vcache.MockExternalCache;
import com.atlassian.vcache.DirectExternalCache;
import com.atlassian.vcache.ExternalCacheSettings;
import com.atlassian.vcache.JvmCache;
import com.atlassian.vcache.JvmCacheSettings;
import com.atlassian.vcache.Marshaller;
import com.atlassian.vcache.RequestCache;
import com.atlassian.vcache.StableReadExternalCache;
import com.atlassian.vcache.TransactionalExternalCache;
import com.atlassian.vcache.VCacheFactory;
import com.atlassian.vcache.internal.RequestContext;
import com.atlassian.vcache.internal.core.DefaultRequestCache;
import com.atlassian.vcache.internal.core.DefaultRequestContext;
import java.util.function.Supplier;
import javax.annotation.Nonnull;
import javax.annotation.ParametersAreNonnullByDefault;

@ParametersAreNonnullByDefault
public class MockVCacheFactory
implements VCacheFactory {
    @Nonnull
    public <K, V> JvmCache<K, V> getJvmCache(String s, JvmCacheSettings jvmCacheSettings) {
        throw new UnsupportedOperationException("Not implemented");
    }

    @Nonnull
    public <K, V> RequestCache<K, V> getRequestCache(String s) {
        return new DefaultRequestCache(s, (Supplier)new ThreadAwareContextSupplier());
    }

    @Nonnull
    public <V> TransactionalExternalCache<V> getTransactionalExternalCache(String s, Marshaller<V> marshaller, ExternalCacheSettings externalCacheSettings) {
        throw new UnsupportedOperationException("Not implemented");
    }

    @Nonnull
    public <V> StableReadExternalCache<V> getStableReadExternalCache(String cacheName, Marshaller<V> marshaller, ExternalCacheSettings externalCacheSettings) {
        return new MockExternalCache<V>(cacheName, marshaller, externalCacheSettings);
    }

    @Nonnull
    public <V> DirectExternalCache<V> getDirectExternalCache(String cacheName, Marshaller<V> marshaller, ExternalCacheSettings externalCacheSettings) {
        return new MockExternalCache<V>(cacheName, marshaller, externalCacheSettings);
    }

    static class ThreadAwareContextSupplier
    implements Supplier<RequestContext> {
        private final ThreadLocal<RequestContext> localRequestContext = new ThreadLocal<RequestContext>(){

            @Override
            protected RequestContext initialValue() {
                return new DefaultRequestContext("staticTenant" + this.hashCode());
            }
        };

        ThreadAwareContextSupplier() {
        }

        @Override
        public RequestContext get() {
            return this.localRequestContext.get();
        }
    }
}

