/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.database;

import com.atlassian.jira.database.DuckTypePreparedStatement;
import com.atlassian.jira.database.ResultRow;
import com.atlassian.jira.util.DuckTypeProxyFactory;
import com.google.common.collect.Sets;
import java.sql.PreparedStatement;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Supplier;
import javax.annotation.Nonnull;
import org.apache.commons.lang3.StringEscapeUtils;

public class DuckTypeConnection {
    private Map<String, Iterable<ResultRow>> queryResults = new ConcurrentHashMap<String, Iterable<ResultRow>>();
    private Map<String, Supplier<Integer>> updateResults = new ConcurrentHashMap<String, Supplier<Integer>>();
    private Map<String, Runnable> sqlQueryActions = new ConcurrentHashMap<String, Runnable>();
    private Set<String> queriesRun = Sets.newSetFromMap(new ConcurrentHashMap());
    private Optional<Iterable<ResultRow>> defaultQueryResult = Optional.empty();
    private Optional<Integer> defaultUpdateResult = Optional.empty();

    public void reset() {
        this.queryResults.clear();
        this.updateResults.clear();
        this.sqlQueryActions.clear();
        this.queriesRun.clear();
    }

    public PreparedStatement prepareStatement(String sql) {
        return DuckTypeProxyFactory.newStrictProxyInstance(PreparedStatement.class, new DuckTypePreparedStatement(this, sql));
    }

    public void setAutoCommit(boolean autoCommit) {
    }

    public void commit() {
    }

    public void setQueryResults(String sql, Iterable<ResultRow> expectedResults) {
        this.queryResults.put(sql, expectedResults);
    }

    @Nonnull
    public Iterable<ResultRow> getQueryResults(String sql) {
        Iterable<ResultRow> resultRows = this.queryResults.get(sql);
        if (resultRows == null) {
            return this.defaultQueryResult.orElseThrow(() -> new AssertionError((Object)("Unexpected DB call: \n\n" + sql + "\n")));
        }
        this.runSqlQueryAction(sql);
        return resultRows;
    }

    public void setUpdateResults(String sql, int rowCount) {
        this.updateResults.put(sql, () -> rowCount);
    }

    public void setUpdateResults(String sql, Supplier<RuntimeException> exFactory) {
        this.updateResults.put(sql, () -> {
            throw (RuntimeException)Objects.requireNonNull(exFactory.get(), "exFactory.get()");
        });
    }

    public int getUpdateResults(String sql) {
        Supplier<Integer> rowCount = this.updateResults.get(sql);
        if (rowCount == null) {
            return this.defaultUpdateResult.orElseThrow(() -> new AssertionError((Object)("Unexpected DB call: \n\n" + sql + "\n")));
        }
        this.runSqlQueryAction(sql);
        return rowCount.get();
    }

    public void setDefaultQueryResult(Iterable<ResultRow> defaultQueryResult) {
        this.defaultQueryResult = Optional.of(defaultQueryResult);
    }

    public void setDefaultUpdateResult(int defaultUpdateResult) {
        this.defaultUpdateResult = Optional.of(defaultUpdateResult);
    }

    public void assertAllExpectedStatementsWereRun() {
        try {
            this.assertStatementsRun(this.queryResults.keySet());
            this.assertStatementsRun(this.updateResults.keySet());
        }
        finally {
            this.queryResults.clear();
            this.updateResults.clear();
            this.queriesRun.clear();
        }
    }

    private void assertStatementsRun(Set<String> expectedStatements) {
        for (String expectedStatement : expectedStatements) {
            if (!this.queriesRun.contains(expectedStatement)) {
                throw new AssertionError((Object)("The following SQL was expected to run but was not: \n\n" + expectedStatement + "\n"));
            }
        }
    }

    public void onSqlListener(String sql, Runnable action) {
        this.sqlQueryActions.put(sql, action);
    }

    protected void runSqlQueryAction(String sql) {
        this.queriesRun.add(sql);
        Runnable callback = this.sqlQueryActions.get(sql);
        if (callback != null) {
            callback.run();
        }
    }

    public String toString() {
        StringBuilder sb = new StringBuilder(4096).append("DuckTypeConnection {{{");
        DuckTypeConnection.appendResults(sb, "queryResults", this.queryResults);
        DuckTypeConnection.appendResults(sb, "updateResults", this.updateResults);
        if (!this.queriesRun.isEmpty()) {
            sb.append("\n\tqueriesRun:\n");
            this.queriesRun.forEach(query -> {
                DuckTypeConnection.appendQuery(sb, query);
                sb.append('\n');
            });
        }
        return sb.append("}}}").toString();
    }

    private static void appendResults(StringBuilder sb, String name, Map<String, ?> results) {
        if (results.isEmpty()) {
            return;
        }
        sb.append("\n\t").append(name).append(":\n");
        results.forEach((query, result) -> {
            DuckTypeConnection.appendQuery(sb, query);
            sb.append(" => ").append(result).append('\n');
        });
    }

    private static void appendQuery(StringBuilder sb, String query) {
        sb.append("\t\t\"").append(StringEscapeUtils.escapeJava((String)query)).append('\"');
    }
}

