/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.database;

import com.atlassian.jira.database.DuckTypePreparedStatement;
import com.atlassian.jira.database.ResultRow;
import java.math.BigDecimal;
import java.sql.Date;
import java.sql.SQLException;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.Iterator;

public class DuckTypeResultSet {
    private final Iterator<ResultRow> resultsIterator;
    private ResultRow currentResultRow = null;
    private boolean wasNull = false;

    public DuckTypeResultSet(DuckTypePreparedStatement mockPreparedStatement) {
        this.resultsIterator = mockPreparedStatement.getExpectedResults().iterator();
    }

    public boolean next() throws SQLException {
        if (this.resultsIterator.hasNext()) {
            this.currentResultRow = this.resultsIterator.next();
            return true;
        }
        this.currentResultRow = null;
        return false;
    }

    public void close() throws SQLException {
    }

    public boolean wasNull() throws SQLException {
        return this.wasNull;
    }

    public String getString(int columnIndex) throws SQLException {
        return (String)this.currentResultRow.getObject(columnIndex);
    }

    public boolean getBoolean(int columnIndex) throws SQLException {
        Object val = this.getObject(columnIndex);
        return this.wasNull ? false : (Boolean)val;
    }

    public byte getByte(int columnIndex) throws SQLException {
        Object val = this.getObject(columnIndex);
        return this.wasNull ? (byte)0 : (Byte)val;
    }

    public short getShort(int columnIndex) throws SQLException {
        Object val = this.getObject(columnIndex);
        return this.wasNull ? (short)0 : (Short)val;
    }

    public int getInt(int columnIndex) throws SQLException {
        Object val = this.getObject(columnIndex);
        return this.wasNull ? 0 : (Integer)val;
    }

    public long getLong(int columnIndex) throws SQLException {
        Object val = this.getObject(columnIndex);
        return this.wasNull ? 0L : (Long)val;
    }

    public float getFloat(int columnIndex) throws SQLException {
        throw new UnsupportedOperationException("Not implemented");
    }

    public double getDouble(int columnIndex) throws SQLException {
        throw new UnsupportedOperationException("Not implemented");
    }

    public BigDecimal getBigDecimal(int columnIndex, int scale) throws SQLException {
        Object val = this.getObject(columnIndex);
        return (BigDecimal)val;
    }

    public byte[] getBytes(int columnIndex) throws SQLException {
        throw new UnsupportedOperationException("Not implemented");
    }

    public Date getDate(int columnIndex) throws SQLException {
        Object val = this.getObject(columnIndex);
        return (Date)val;
    }

    public Time getTime(int columnIndex) throws SQLException {
        Object val = this.getObject(columnIndex);
        return (Time)val;
    }

    public Timestamp getTimestamp(int columnIndex) throws SQLException {
        Object val = this.getObject(columnIndex);
        return (Timestamp)val;
    }

    public Object getObject(int columnIndex) throws SQLException {
        Object val = this.currentResultRow.getObject(columnIndex);
        this.wasNull = val == null;
        return val;
    }
}

