/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.event;

import com.atlassian.event.api.EventListener;
import java.lang.reflect.Method;
import org.apache.commons.lang.mutable.MutableBoolean;
import org.hamcrest.Description;
import org.hamcrest.Matcher;
import org.junit.internal.matchers.TypeSafeMatcher;
import org.springframework.util.ReflectionUtils;

public class HasEventListenerFor
extends TypeSafeMatcher<Class<?>> {
    private final Class<?> eventClass;

    public static Matcher<Class<?>> hasEventListenerFor(Class<?> eventClass) {
        return new HasEventListenerFor(eventClass);
    }

    public HasEventListenerFor(Class<?> eventClass) {
        if (eventClass == null) {
            throw new NullPointerException("eventClass");
        }
        this.eventClass = eventClass;
    }

    public boolean matchesSafely(Class<?> eventListenerClass) {
        final MutableBoolean handlesNotification = new MutableBoolean();
        ReflectionUtils.doWithMethods(eventListenerClass, (ReflectionUtils.MethodCallback)new ReflectionUtils.MethodCallback(){

            public void doWith(Method method) throws IllegalArgumentException, IllegalAccessException {
                Class<?>[] types;
                if (method.getAnnotation(EventListener.class) != null && (types = method.getParameterTypes()).length == 1 && types[0] == HasEventListenerFor.this.eventClass) {
                    handlesNotification.setValue(true);
                }
            }
        });
        return handlesNotification.booleanValue();
    }

    public void describeTo(Description description) {
        description.appendText(String.format("A class containing an @EventListener method that takes a single argument of type %s", this.eventClass.getSimpleName()));
    }
}

