/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.help;

import com.atlassian.fugue.Option;
import com.atlassian.jira.help.HelpUrl;
import com.atlassian.jira.help.HelpUrls;
import com.atlassian.jira.help.HelpUrlsParser;
import com.atlassian.jira.help.MockHelpUrl;
import com.atlassian.jira.help.MockHelpUrls;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import javax.annotation.Nonnull;

public class MockHelpUrlsParser
implements HelpUrlsParser {
    private static final String DEFAULT_KEY = "default";
    private boolean onDemand;
    private MockHelpUrl defaultUrl;
    private Map<String, MockHelpUrl> btfUrls = Maps.newHashMap();
    private Map<String, MockHelpUrl> odUrls = Maps.newHashMap();
    private Option<String> applicationHelpSpace;

    public MockHelpUrlsParser() {
        this(true, new MockHelpUrl().setKey(DEFAULT_KEY).setUrl("").setTitle(""));
    }

    private MockHelpUrlsParser(boolean onDemand, MockHelpUrl defaultUrl) {
        this.onDemand = onDemand;
        this.defaultUrl = defaultUrl;
    }

    @Nonnull
    public HelpUrlsParser onDemand(boolean onDemand) {
        this.onDemand = onDemand;
        return this;
    }

    @Nonnull
    public HelpUrlsParser defaultUrl(String url, String title) {
        this.defaultUrl.setUrl(url).setTitle(title);
        return this;
    }

    @Nonnull
    public HelpUrls parse(@Nonnull Properties properties) {
        HashMap maps = Maps.newHashMap();
        for (Map.Entry<Object, Object> entry : properties.entrySet()) {
            maps.put(String.valueOf(entry.getKey()), String.valueOf(entry.getValue()));
        }
        return this.parse((Map)maps);
    }

    @Nonnull
    public HelpUrls parse(@Nonnull Properties externalProperties, @Nonnull Properties internalProperties) {
        HelpUrls external = this.parse(externalProperties);
        HelpUrls internal = this.parse(internalProperties);
        return new MockHelpUrls(external.getDefaultUrl(), Iterables.concat((Iterable)external, (Iterable)internal));
    }

    @Nonnull
    public MockHelpUrls parse(@Nonnull Map<String, String> properties) {
        MockHelpUrl defaultUrl = this.defaultUrl.copy();
        defaultUrl.setAlt(properties.get(DEFAULT_KEY));
        ArrayList urls = Lists.newArrayList();
        for (Map.Entry<String, String> entry : properties.entrySet()) {
            String key = entry.getKey();
            if (DEFAULT_KEY.equals(key)) continue;
            urls.add(this.getGeneratedUrl(this.getUrl(entry.getKey()), entry.getValue()));
        }
        return new MockHelpUrls((HelpUrl)defaultUrl, urls);
    }

    @Nonnull
    public HelpUrls parse(Map<String, String> userProperties, Map<String, String> adminProperties) {
        return this.parse((Map)userProperties).merge((MockHelpUrls)this.parse((Map)adminProperties));
    }

    private MockHelpUrl getUrl(String key) {
        if (DEFAULT_KEY.equals(key)) {
            return this.defaultUrl;
        }
        MockHelpUrl result = null;
        if (this.onDemand) {
            result = this.odUrls.get(key);
        }
        if (result == null) {
            result = this.btfUrls.get(key);
        }
        if (result == null) {
            throw new IllegalStateException(String.format("Unable to find URL with key '%s.'", key));
        }
        return result;
    }

    public HelpUrl getDefault() {
        return this.defaultUrl.copy();
    }

    public MockHelpUrlsParser registerOd(HelpUrl url) {
        this.odUrls.put(url.getKey(), new MockHelpUrl(url));
        return this;
    }

    public MockHelpUrlsParser register(HelpUrl url) {
        this.btfUrls.put(url.getKey(), new MockHelpUrl(url));
        return this;
    }

    public MockHelpUrl createUrl(String key, String url) {
        MockHelpUrl mockHelpUrl = new MockHelpUrl().setKey(key).setUrl(url);
        this.register(mockHelpUrl);
        return mockHelpUrl;
    }

    public MockHelpUrl createUrlOd(String key, String url) {
        MockHelpUrl mockHelpUrl = new MockHelpUrl().setKey(key).setUrl(url);
        this.registerOd(mockHelpUrl);
        return mockHelpUrl;
    }

    public HelpUrl getGeneratedUrl(HelpUrl url, String value) {
        return new MockHelpUrl(url).setAlt(value);
    }

    public HelpUrl getGeneratedDefault(String value) {
        return this.defaultUrl.copy().setAlt(value);
    }

    public Option<String> getApplicationHelpSpace() {
        return this.applicationHelpSpace;
    }

    public void setApplicationHelpSpace(Option<String> applicationHelpSpace) {
        this.applicationHelpSpace = applicationHelpSpace;
    }
}

