/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.issue.fields;

import com.atlassian.jira.issue.Issue;
import com.atlassian.jira.issue.fields.ConfigurableField;
import com.atlassian.jira.issue.fields.CustomField;
import com.atlassian.jira.issue.fields.Field;
import com.atlassian.jira.issue.fields.FieldException;
import com.atlassian.jira.issue.fields.FieldManager;
import com.atlassian.jira.issue.fields.HideableField;
import com.atlassian.jira.issue.fields.IssueTypeField;
import com.atlassian.jira.issue.fields.MandatoryField;
import com.atlassian.jira.issue.fields.MockCustomField;
import com.atlassian.jira.issue.fields.MockOrderableField;
import com.atlassian.jira.issue.fields.NavigableField;
import com.atlassian.jira.issue.fields.OrderableField;
import com.atlassian.jira.issue.fields.ProjectField;
import com.atlassian.jira.issue.fields.RequirableField;
import com.atlassian.jira.issue.fields.SearchableField;
import com.atlassian.jira.issue.fields.UnscreenableField;
import com.atlassian.jira.issue.fields.layout.column.ColumnLayoutManager;
import com.atlassian.jira.issue.fields.layout.field.FieldLayout;
import com.atlassian.jira.issue.fields.layout.field.FieldLayoutManager;
import com.atlassian.jira.issue.fields.renderer.RenderableField;
import com.atlassian.jira.jql.context.QueryContext;
import com.atlassian.jira.user.ApplicationUser;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import javax.annotation.Nullable;
import org.apache.commons.lang.builder.ToStringBuilder;
import org.apache.commons.lang.builder.ToStringStyle;

public class MockFieldManager
implements FieldManager {
    private Map<String, Field> fields = new HashMap<String, Field>();
    private Set<Field> unavailable = new HashSet<Field>();

    public MockOrderableField addMockOrderableField(int id) {
        String stringId = String.valueOf(id);
        MockOrderableField mockOrderableField = new MockOrderableField(stringId, stringId);
        this.addField((Field)mockOrderableField);
        return mockOrderableField;
    }

    public MockCustomField addMockCustomField(int id) {
        String stringId = String.valueOf(id);
        MockCustomField mockCustomField = new MockCustomField().setId(stringId);
        this.addField((Field)mockCustomField);
        return mockCustomField;
    }

    public MockFieldManager addField(Field field) {
        this.fields.put(field.getId(), field);
        return this;
    }

    public MockFieldManager addUnavilableField(Field field) {
        this.unavailable.add(field);
        return this;
    }

    public MockFieldManager clear() {
        this.unavailable.clear();
        this.fields.clear();
        return this;
    }

    public Field getField(String id) {
        return this.fields.get(id);
    }

    public boolean isCustomField(String id) {
        return this.isCustomField(this.getField(id));
    }

    public boolean isCustomFieldId(String id) {
        return id != null && id.startsWith("customfield_");
    }

    public boolean isExistingCustomField(String id) {
        return this.isCustomField(this.getField(id));
    }

    public boolean isCustomField(Field field) {
        return field instanceof CustomField;
    }

    @Nullable
    public CustomField getCustomField(String id) {
        return this.getFieldType(id, CustomField.class);
    }

    public boolean isHideableField(String id) {
        return this.isHideableField(this.getField(id));
    }

    public boolean isHideableField(Field field) {
        return field instanceof HideableField;
    }

    public HideableField getHideableField(String id) {
        return this.getFieldType(id, HideableField.class);
    }

    public boolean isOrderableField(String id) {
        return this.isOrderableField(this.getField(id));
    }

    public boolean isOrderableField(Field field) {
        return field instanceof OrderableField;
    }

    public OrderableField getOrderableField(String id) {
        return this.getFieldType(id, OrderableField.class);
    }

    public ConfigurableField getConfigurableField(String id) {
        return this.getFieldType(id, ConfigurableField.class);
    }

    public Set<OrderableField> getOrderableFields() {
        return this.getFieldsOfType(OrderableField.class, new HashSet());
    }

    public Set<NavigableField> getNavigableFields() {
        return this.getFieldsOfType(NavigableField.class, new HashSet());
    }

    public boolean isNavigableField(String id) {
        return this.isNavigableField(this.getField(id));
    }

    public boolean isNavigableField(Field field) {
        return field instanceof NavigableField;
    }

    public NavigableField getNavigableField(String id) {
        return this.getFieldType(id, NavigableField.class);
    }

    public boolean isRequirableField(String id) {
        return this.isRequirableField(this.getField(id));
    }

    public boolean isRequirableField(Field field) {
        return field instanceof RequirableField;
    }

    public boolean isMandatoryField(String id) {
        return this.isMandatoryField(this.getField(id));
    }

    public boolean isMandatoryField(Field field) {
        return field instanceof MandatoryField;
    }

    public boolean isRenderableField(String id) {
        return this.isRenderableField(this.getField(id));
    }

    public boolean isRenderableField(Field field) {
        return field instanceof RenderableField;
    }

    public boolean isUnscreenableField(String id) {
        return this.isUnscreenableField(this.getField(id));
    }

    public boolean isUnscreenableField(Field field) {
        return field instanceof UnscreenableField;
    }

    public RequirableField getRequiredField(String id) {
        return this.getFieldType(id, RequirableField.class);
    }

    public FieldLayoutManager getFieldLayoutManager() {
        throw new UnsupportedOperationException();
    }

    public ColumnLayoutManager getColumnLayoutManager() {
        throw new UnsupportedOperationException();
    }

    public void refresh() {
    }

    public Set<Field> getUnavailableFields() {
        return this.unavailable;
    }

    public boolean isFieldHidden(ApplicationUser remoteUser, Field field) {
        throw new UnsupportedOperationException();
    }

    public boolean isFieldHidden(Set<FieldLayout> fieldLayouts, Field field) {
        throw new UnsupportedOperationException("Not implemented");
    }

    public Set<FieldLayout> getVisibleFieldLayouts(ApplicationUser user) {
        throw new UnsupportedOperationException("Not implemented");
    }

    public boolean isFieldHidden(ApplicationUser remoteUser, String fieldId) {
        throw new UnsupportedOperationException();
    }

    public Set<NavigableField> getAvailableNavigableFieldsWithScope(ApplicationUser user) throws FieldException {
        throw new UnsupportedOperationException();
    }

    public Set<NavigableField> getAvailableNavigableFieldsWithScope(ApplicationUser user, QueryContext queryContext) throws FieldException {
        throw new UnsupportedOperationException();
    }

    public Set<CustomField> getAvailableCustomFields(ApplicationUser remoteUser, Issue issue) throws FieldException {
        throw new UnsupportedOperationException();
    }

    public Set<NavigableField> getAllAvailableNavigableFields() throws FieldException {
        throw new UnsupportedOperationException();
    }

    public Set<NavigableField> getAvailableNavigableFields(ApplicationUser remoteUser) throws FieldException {
        throw new UnsupportedOperationException();
    }

    public Set<SearchableField> getAllSearchableFields() {
        throw new UnsupportedOperationException();
    }

    public Set<SearchableField> getSystemSearchableFields() {
        throw new UnsupportedOperationException();
    }

    public IssueTypeField getIssueTypeField() {
        throw new UnsupportedOperationException();
    }

    public ProjectField getProjectField() {
        throw new UnsupportedOperationException();
    }

    public boolean isTimeTrackingOn() {
        return false;
    }

    private <T> T getFieldType(String id, Class<T> k) {
        Field field = this.getField(id);
        if (field != null && k.isAssignableFrom(field.getClass())) {
            return k.cast(field);
        }
        return null;
    }

    private <T, K extends Collection<T>> K getFieldsOfType(Class<T> klazz, K coll) {
        for (Field f : this.fields.values()) {
            if (!klazz.isAssignableFrom(f.getClass())) continue;
            coll.add(klazz.cast(f));
        }
        return coll;
    }

    public String toString() {
        return ToStringBuilder.reflectionToString((Object)this, (ToStringStyle)ToStringStyle.SHORT_PREFIX_STYLE);
    }
}

