/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.issue.fields.layout.field;

import com.atlassian.jira.issue.Issue;
import com.atlassian.jira.issue.fields.layout.field.EditableDefaultFieldLayout;
import com.atlassian.jira.issue.fields.layout.field.EditableFieldLayout;
import com.atlassian.jira.issue.fields.layout.field.FieldConfigurationScheme;
import com.atlassian.jira.issue.fields.layout.field.FieldLayout;
import com.atlassian.jira.issue.fields.layout.field.FieldLayoutManager;
import com.atlassian.jira.issue.fields.layout.field.FieldLayoutScheme;
import com.atlassian.jira.issue.fields.layout.field.FieldLayoutSchemeEntity;
import com.atlassian.jira.issue.fields.layout.field.MockFieldLayout;
import com.atlassian.jira.issue.issuetype.IssueType;
import com.atlassian.jira.project.Project;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.apache.commons.lang.builder.ToStringBuilder;
import org.apache.commons.lang.builder.ToStringStyle;
import org.ofbiz.core.entity.GenericValue;

public class MockFieldLayoutManager
implements FieldLayoutManager {
    private Map<Context, FieldLayout> contextToLayout = new HashMap<Context, FieldLayout>();
    private Map<Long, FieldLayout> idsToLayout = new HashMap<Long, FieldLayout>();
    private long currentId = 10101L;
    private List<FieldLayoutScheme> fieldLayoutSchemes;
    private Map<Project, FieldConfigurationScheme> fieldConfigurationSchemes = new HashMap<Project, FieldConfigurationScheme>();
    private Map<Long, FieldConfigurationScheme> fieldConfigurationSchemeIds = new HashMap<Long, FieldConfigurationScheme>();

    public MockFieldLayout addLayoutItem(Issue issue) {
        MockFieldLayout item = new MockFieldLayout();
        item.setId(this.currentId++);
        this.contextToLayout.put(new Context(issue), item);
        this.idsToLayout.put(item.getId(), item);
        return item;
    }

    public FieldLayoutScheme createFieldLayoutScheme(FieldLayoutScheme fieldLayoutScheme) {
        throw new UnsupportedOperationException();
    }

    public FieldLayoutScheme createFieldLayoutScheme(@Nonnull String name, @Nullable String description) {
        throw new UnsupportedOperationException("Not implemented");
    }

    public FieldLayoutScheme copyFieldLayoutScheme(@Nonnull FieldLayoutScheme scheme, @Nonnull String name, @Nullable String description) {
        throw new UnsupportedOperationException("Not implemented");
    }

    public FieldConfigurationScheme getFieldConfigurationScheme(Long schemeId) {
        return this.fieldConfigurationSchemeIds.get(schemeId);
    }

    public FieldLayoutScheme getMutableFieldLayoutScheme(Long schemeId) {
        throw new UnsupportedOperationException();
    }

    public boolean fieldConfigurationSchemeExists(String schemeName) {
        return false;
    }

    public List<EditableFieldLayout> getEditableFieldLayouts() {
        throw new UnsupportedOperationException();
    }

    public List<FieldLayoutScheme> getFieldLayoutSchemes() {
        return this.fieldLayoutSchemes;
    }

    public MockFieldLayoutManager setFieldLayoutSchemes(List<FieldLayoutScheme> fieldLayoutSchemes) {
        this.fieldLayoutSchemes = fieldLayoutSchemes;
        return this;
    }

    public void updateFieldLayoutScheme(FieldLayoutScheme fieldLayoutScheme) {
        throw new UnsupportedOperationException();
    }

    public void deleteFieldLayoutScheme(FieldLayoutScheme fieldLayoutScheme) {
        throw new UnsupportedOperationException();
    }

    public FieldConfigurationScheme getFieldConfigurationScheme(Project project) {
        return this.fieldConfigurationSchemes.get(project);
    }

    public FieldConfigurationScheme getFieldConfigurationSchemeForProject(@Nonnull Long projectId) {
        throw new UnsupportedOperationException("Not implemented");
    }

    public MockFieldLayoutManager setFieldConfigurationScheme(Project project, FieldConfigurationScheme fieldConfigurationScheme) {
        this.fieldConfigurationSchemes.put(project, fieldConfigurationScheme);
        return this;
    }

    public MockFieldLayoutManager setFieldConfigurationScheme(Long id, FieldConfigurationScheme fieldConfigurationScheme) {
        this.fieldConfigurationSchemeIds.put(id, fieldConfigurationScheme);
        return this;
    }

    public Set<FieldLayout> getUniqueFieldLayouts(Project project) {
        HashSet<FieldLayout> uniqLayouts = new HashSet<FieldLayout>();
        for (Map.Entry<Context, FieldLayout> layoutEntry : this.contextToLayout.entrySet()) {
            if (!project.getId().equals(layoutEntry.getKey().getProject())) continue;
            uniqLayouts.add(layoutEntry.getValue());
        }
        return uniqLayouts;
    }

    @Nonnull
    public Set<FieldLayout> getUniqueFieldLayouts(@Nonnull Collection<Project> projects, @Nonnull Collection<String> issueTypeIds) {
        HashSet<FieldLayout> uniqLayouts = new HashSet<FieldLayout>();
        for (Project project : projects) {
            for (String issueTypeId : issueTypeIds) {
                uniqLayouts.add(this.getFieldLayout(project, issueTypeId));
            }
        }
        return uniqLayouts;
    }

    public void addSchemeAssociation(GenericValue project, Long fieldLayoutSchemeId) {
        throw new UnsupportedOperationException();
    }

    public void removeSchemeAssociation(GenericValue project, Long fieldLayoutSchemeId) {
        throw new UnsupportedOperationException();
    }

    public void addSchemeAssociation(Project project, Long fieldLayoutSchemeId) {
        throw new UnsupportedOperationException("Not implemented");
    }

    public void removeSchemeAssociation(Project project, Long fieldLayoutSchemeId) {
        throw new UnsupportedOperationException("Not implemented");
    }

    public FieldLayout getFieldLayout() {
        return this.getFieldLayout((Long)null);
    }

    public FieldLayout getFieldLayout(Long id) {
        return this.idsToLayout.get(id);
    }

    public MockFieldLayoutManager setFieldLayout(Long id, FieldLayout fieldLayout) {
        this.idsToLayout.put(id, fieldLayout);
        return this;
    }

    public FieldLayout getFieldLayout(GenericValue issue) {
        return this.contextToLayout.get(new Context(issue.getLong("project"), issue.getString("type")));
    }

    public FieldLayout getFieldLayout(Issue issue) {
        return this.contextToLayout.get(new Context(issue));
    }

    public FieldLayout getFieldLayout(Project project, String issueTypeId) {
        return this.contextToLayout.get(new Context(project.getId(), issueTypeId));
    }

    public FieldLayout getFieldLayout(@Nonnull Long projectId, @Nonnull String issueTypeId) {
        throw new UnsupportedOperationException("Not implemented");
    }

    public MockFieldLayoutManager setFieldLayout(Project project, String issueTypeId, FieldLayout fieldLayout) {
        this.contextToLayout.put(new Context(project.getId(), issueTypeId), fieldLayout);
        return this;
    }

    public EditableDefaultFieldLayout getEditableDefaultFieldLayout() {
        throw new UnsupportedOperationException();
    }

    public void storeEditableDefaultFieldLayout(EditableDefaultFieldLayout editableDefaultFieldLayout) {
        throw new UnsupportedOperationException();
    }

    public void storeEditableFieldLayout(EditableFieldLayout editableFieldLayout) {
        throw new UnsupportedOperationException();
    }

    public EditableFieldLayout storeAndReturnEditableFieldLayout(EditableFieldLayout editableFieldLayout) {
        throw new UnsupportedOperationException();
    }

    public void restoreDefaultFieldLayout() {
        throw new UnsupportedOperationException();
    }

    public boolean hasDefaultFieldLayout() {
        return false;
    }

    public Collection<GenericValue> getProjects(FieldConfigurationScheme fieldConfigurationScheme) {
        throw new UnsupportedOperationException();
    }

    public Collection<Project> getProjectsUsing(FieldConfigurationScheme fieldConfigurationScheme) {
        throw new UnsupportedOperationException("Not implemented");
    }

    public Collection<GenericValue> getProjects(FieldLayoutScheme fieldLayoutScheme) {
        throw new UnsupportedOperationException();
    }

    public Collection<Project> getProjectsUsing(FieldLayoutScheme fieldLayoutScheme) {
        throw new UnsupportedOperationException();
    }

    public void refresh() {
    }

    public EditableFieldLayout getEditableFieldLayout(Long id) {
        throw new UnsupportedOperationException();
    }

    public void deleteFieldLayout(FieldLayout fieldLayout) {
        MockFieldLayoutManager.deleteValue(this.contextToLayout, fieldLayout);
        MockFieldLayoutManager.deleteValue(this.idsToLayout, fieldLayout);
    }

    public Collection<FieldLayoutSchemeEntity> getFieldLayoutSchemeEntities(FieldLayoutScheme fieldLayoutScheme) {
        throw new UnsupportedOperationException();
    }

    public void createFieldLayoutSchemeEntity(FieldLayoutSchemeEntity fieldLayoutSchemeEntity) {
        throw new UnsupportedOperationException();
    }

    public FieldLayoutSchemeEntity createFieldLayoutSchemeEntity(FieldLayoutScheme fieldLayoutScheme, String issueTypeId, Long fieldConfigurationId) {
        throw new UnsupportedOperationException("Not implemented");
    }

    public void updateFieldLayoutSchemeEntity(FieldLayoutSchemeEntity fieldLayoutSchemeEntity) {
        throw new UnsupportedOperationException();
    }

    public void removeFieldLayoutSchemeEntity(FieldLayoutSchemeEntity fieldLayoutSchemeEntity) {
        throw new UnsupportedOperationException();
    }

    public void removeFieldLayoutScheme(FieldLayoutScheme fieldLayoutScheme) {
        throw new UnsupportedOperationException();
    }

    public Collection<FieldConfigurationScheme> getFieldConfigurationSchemes(FieldLayout fieldLayout) {
        throw new UnsupportedOperationException();
    }

    public Collection<GenericValue> getRelatedProjects(FieldLayout fieldLayout) {
        throw new UnsupportedOperationException();
    }

    public Collection<Project> getProjectsUsing(FieldLayout fieldLayout) {
        throw new UnsupportedOperationException();
    }

    public boolean isFieldLayoutSchemesVisiblyEquivalent(Long fieldConfigurationSchemeId1, Long fieldConfigurationSchemeId2) {
        throw new UnsupportedOperationException();
    }

    public boolean isFieldLayoutsVisiblyEquivalent(Long fieldLayoutId1, Long fieldLayoutId2) {
        return false;
    }

    private static void deleteValue(Map<?, FieldLayout> layoutMap, FieldLayout layout) {
        Iterator<FieldLayout> iterator = layoutMap.values().iterator();
        while (iterator.hasNext()) {
            FieldLayout fieldLayout = iterator.next();
            if (!fieldLayout.equals(layout)) continue;
            iterator.remove();
        }
    }

    public String toString() {
        return ToStringBuilder.reflectionToString((Object)this, (ToStringStyle)ToStringStyle.SHORT_PREFIX_STYLE);
    }

    private static class Context {
        private final Long project;
        private final String issueType;

        private Context(Long project, String issueType) {
            this.project = project;
            this.issueType = issueType;
        }

        private Context(Issue issue) {
            Project projectObject = issue.getProjectObject();
            this.project = projectObject != null ? projectObject.getId() : null;
            IssueType issueType = issue.getIssueTypeObject();
            this.issueType = issueType != null ? issueType.getId() : null;
        }

        public Long getProject() {
            return this.project;
        }

        public String getIssueType() {
            return this.issueType;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            Context context = (Context)o;
            if (this.issueType != null ? !this.issueType.equals(context.issueType) : context.issueType != null) {
                return false;
            }
            return !(this.project != null ? !this.project.equals(context.project) : context.project != null);
        }

        public int hashCode() {
            int result = this.project != null ? this.project.hashCode() : 0;
            result = 31 * result + (this.issueType != null ? this.issueType.hashCode() : 0);
            return result;
        }
    }
}

