/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.issue.fields.screen;

import com.atlassian.jira.issue.fields.screen.FieldScreen;
import com.atlassian.jira.issue.fields.screen.FieldScreenScheme;
import com.atlassian.jira.issue.fields.screen.FieldScreenSchemeItem;
import com.atlassian.jira.issue.fields.screen.MockFieldScreen;
import com.atlassian.jira.issue.operation.IssueOperation;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.util.Collection;
import java.util.Map;
import org.ofbiz.core.entity.GenericValue;

public class MockFieldScreenScheme
implements FieldScreenScheme {
    private Long id;
    private String name;
    private String description;
    private GenericValue genericValue;
    private Collection<FieldScreenSchemeItem> fieldScreenSchemeItems = Lists.newArrayList();
    private FieldScreen defaultScreen;
    private Map<IssueOperation, FieldScreenSchemeItem> issueOperationToFieldScreenSchemeItemMapping = Maps.newHashMap();
    private Map<IssueOperation, FieldScreen> issueOperationToFieldScreenMapping = Maps.newHashMap();

    public Long getId() {
        return this.id;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public GenericValue getGenericValue() {
        return this.genericValue;
    }

    public void setGenericValue(GenericValue genericValue) {
        this.genericValue = genericValue;
    }

    public FieldScreenSchemeItem getFieldScreenSchemeItem(IssueOperation issueOperation) {
        return this.issueOperationToFieldScreenSchemeItemMapping.get(issueOperation);
    }

    public MockFieldScreenScheme addFieldScreenSchemeItem(IssueOperation issueOperation, FieldScreenSchemeItem fieldScreenSchemeItem) {
        this.issueOperationToFieldScreenSchemeItemMapping.put(issueOperation, fieldScreenSchemeItem);
        return this;
    }

    public Collection<FieldScreenSchemeItem> getFieldScreenSchemeItems() {
        return this.fieldScreenSchemeItems;
    }

    public void addFieldScreenSchemeItem(FieldScreenSchemeItem fieldScreenSchemeItem) {
        this.fieldScreenSchemeItems.add(fieldScreenSchemeItem);
    }

    public FieldScreenSchemeItem removeFieldScreenSchemeItem(IssueOperation issueOperation) {
        return this.issueOperationToFieldScreenSchemeItemMapping.remove(issueOperation);
    }

    public FieldScreen getFieldScreen(IssueOperation issueOperation) {
        FieldScreen fieldScreen = this.issueOperationToFieldScreenMapping.get(issueOperation);
        if (fieldScreen == null) {
            return this.defaultScreen;
        }
        return fieldScreen;
    }

    public MockFieldScreenScheme addFieldScreen(IssueOperation operation, FieldScreen fieldScreen) {
        this.issueOperationToFieldScreenMapping.put(operation, fieldScreen);
        return this;
    }

    public MockFieldScreen createFieldScreen(IssueOperation operation) {
        MockFieldScreen fieldScreen = new MockFieldScreen(this.getNextItemId());
        this.addFieldScreen(operation, fieldScreen);
        return fieldScreen;
    }

    public MockFieldScreen createDefaultScreen() {
        MockFieldScreen fieldScreen = new MockFieldScreen(this.getNextItemId());
        this.defaultScreen = fieldScreen;
        return fieldScreen;
    }

    private long getNextItemId() {
        long max = -1L;
        for (FieldScreen item : this.issueOperationToFieldScreenMapping.values()) {
            if (item.getId() == null) continue;
            max = Math.max(item.getId() & 0xFFFFFFFFL, max);
        }
        return this.id << 32 | max + 1L;
    }

    public void store() {
        throw new UnsupportedOperationException("Not implemented yet");
    }

    public void remove() {
        throw new UnsupportedOperationException("Not implemented yet");
    }

    public MockFieldScreenScheme setDefaultScreen(FieldScreen defaultScreen) {
        this.defaultScreen = defaultScreen;
        return this;
    }
}

