/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.issue.index;

import com.atlassian.jira.component.ComponentAccessor;
import com.atlassian.jira.config.properties.ApplicationProperties;
import com.atlassian.jira.exception.DataAccessException;
import com.atlassian.jira.index.SearchExtractorRegistrationManager;
import com.atlassian.jira.issue.Issue;
import com.atlassian.jira.issue.IssueManager;
import com.atlassian.jira.issue.changehistory.ChangeHistoryGroup;
import com.atlassian.jira.issue.changehistory.ChangeHistoryItem;
import com.atlassian.jira.issue.comments.Comment;
import com.atlassian.jira.issue.comments.CommentComparator;
import com.atlassian.jira.issue.comments.MockComment;
import com.atlassian.jira.issue.index.ChangeHistoryDocumentFactory;
import com.atlassian.jira.issue.index.CommentDocumentFactory;
import com.atlassian.jira.issue.index.DefaultChangeHistoryDocumentFactory;
import com.atlassian.jira.issue.index.DefaultCommentDocumentFactory;
import com.atlassian.jira.issue.index.DefaultIssueDocumentFactory;
import com.atlassian.jira.issue.index.DefaultIssueIndexer;
import com.atlassian.jira.issue.index.DefaultWorklogDocumentFactory;
import com.atlassian.jira.issue.index.DefaultWorklogRetriever;
import com.atlassian.jira.issue.index.IndexDirectoryFactory;
import com.atlassian.jira.issue.index.IssueDocumentFactory;
import com.atlassian.jira.issue.index.MockIndexDirectoryFactory;
import com.atlassian.jira.issue.index.WorklogDocumentFactory;
import com.atlassian.jira.mock.MockApplicationProperties;
import com.atlassian.jira.util.Function;
import com.atlassian.jira.util.JiraDateUtils;
import com.atlassian.jira.util.searchers.MockSearcherFactory;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import org.apache.lucene.store.Directory;
import org.ofbiz.core.entity.GenericEntityException;
import org.ofbiz.core.entity.GenericValue;

public class MemoryIssueIndexer
extends DefaultIssueIndexer {
    public MemoryIssueIndexer() {
        this(new Function<IndexDirectoryFactory.Name, Directory>(){

            public Directory get(IndexDirectoryFactory.Name type) {
                return MockSearcherFactory.getCleanRAMDirectory();
            }
        }, (IssueManager)ComponentAccessor.getComponentOfType(IssueManager.class));
    }

    public MemoryIssueIndexer(Function<IndexDirectoryFactory.Name, Directory> directorySupplier, IssueManager issueManager) {
        this(directorySupplier, issueManager, new MockApplicationProperties());
    }

    public MemoryIssueIndexer(Function<IndexDirectoryFactory.Name, Directory> directorySupplier, IssueManager issueManager, ApplicationProperties applicationProperties) {
        super((IndexDirectoryFactory)new MockIndexDirectoryFactory(directorySupplier, applicationProperties), (DefaultIssueIndexer.CommentRetriever)new CommentRetrieverImpl(issueManager), (DefaultIssueIndexer.ChangeHistoryRetriever)new ChangeHistoryRetrieverImpl(issueManager), (DefaultIssueIndexer.WorklogRetriever)new DefaultWorklogRetriever(), applicationProperties, (IssueDocumentFactory)new DefaultIssueDocumentFactory((SearchExtractorRegistrationManager)ComponentAccessor.getComponentOfType(SearchExtractorRegistrationManager.class)), (CommentDocumentFactory)new DefaultCommentDocumentFactory((SearchExtractorRegistrationManager)ComponentAccessor.getComponentOfType(SearchExtractorRegistrationManager.class)), (ChangeHistoryDocumentFactory)new DefaultChangeHistoryDocumentFactory((SearchExtractorRegistrationManager)ComponentAccessor.getComponentOfType(SearchExtractorRegistrationManager.class)), (WorklogDocumentFactory)new DefaultWorklogDocumentFactory((SearchExtractorRegistrationManager)ComponentAccessor.getComponentOfType(SearchExtractorRegistrationManager.class)), issueManager);
    }

    private static class SimpleComment
    extends MockComment {
        SimpleComment(GenericValue gv, Issue issue) {
            super(gv.getLong("id"), gv.getString("author"), gv.getString("updateauthor"), gv.getString("body"), gv.getString("level"), gv.getLong("rolelevel"), JiraDateUtils.copyDateNullsafe((Date)gv.getTimestamp("created")), JiraDateUtils.copyDateNullsafe((Date)gv.getTimestamp("updated")), issue);
        }
    }

    static class ChangeHistoryRetrieverImpl
    implements DefaultIssueIndexer.ChangeHistoryRetriever {
        private final IssueManager issueManager;

        public ChangeHistoryRetrieverImpl(IssueManager issueManager) {
            this.issueManager = issueManager;
        }

        public List<ChangeHistoryGroup> apply(Issue issue) {
            ArrayList<ChangeHistoryGroup> changeGroups = new ArrayList<ChangeHistoryGroup>();
            try {
                List allChanges = this.issueManager.getEntitiesByIssueObject("IssueChangeGroups", issue);
                for (GenericValue element : allChanges) {
                    ArrayList<ChangeHistoryItem> changes = new ArrayList<ChangeHistoryItem>();
                    List changeitems = element.getRelated("ChildChangeItem");
                    for (GenericValue changeItem : changeitems) {
                        changes.add(new ChangeHistoryItem(changeItem.getLong("id"), changeItem.getLong("group"), issue.getProjectObject().getId(), issue.getId(), issue.getKey(), "status", new Timestamp(System.currentTimeMillis()), changeItem.getString("oldstring"), changeItem.getString("newstring"), changeItem.getString("oldvalue"), changeItem.getString("newvalue"), element.getString("author")));
                    }
                    changeGroups.add(new ChangeHistoryGroup(element.getLong("id"), issue.getProjectObject().getId(), issue.getId(), issue.getKey(), element.getString("author"), changes, element.getTimestamp("created")));
                }
            }
            catch (Exception e) {
                throw new DataAccessException((Throwable)e);
            }
            return changeGroups;
        }
    }

    static class CommentRetrieverImpl
    implements DefaultIssueIndexer.CommentRetriever {
        private final IssueManager issueManager;

        public CommentRetrieverImpl(IssueManager issueManager) {
            this.issueManager = issueManager;
        }

        public List<Comment> apply(Issue issue) {
            ArrayList<Comment> comments = new ArrayList<Comment>();
            try {
                List allComments = this.issueManager.getEntitiesByIssueObject("IssueComments", issue);
                for (GenericValue element : allComments) {
                    comments.add((Comment)new SimpleComment(element, issue));
                }
            }
            catch (GenericEntityException e) {
                throw new DataAccessException((Throwable)e);
            }
            Collections.sort(comments, CommentComparator.COMPARATOR);
            return comments;
        }
    }
}

