/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.issue.link;

import com.atlassian.jira.issue.Issue;
import com.atlassian.jira.issue.link.RemoteIssueLink;
import com.atlassian.jira.issue.link.RemoteIssueLinkBuilder;
import com.atlassian.jira.issue.link.RemoteIssueLinkStore;
import com.google.common.base.Predicate;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Nullable;

public class MemoryRemoteIssueLinkStore
implements RemoteIssueLinkStore {
    private final Map<Long, RemoteIssueLink> remoteIssueLinks = new HashMap<Long, RemoteIssueLink>();
    private volatile long nextId;

    public RemoteIssueLink getRemoteIssueLink(Long remoteIssueLinkId) {
        return this.remoteIssueLinks.get(remoteIssueLinkId);
    }

    public List<RemoteIssueLink> getRemoteIssueLinksForIssue(Issue issue) {
        ArrayList<RemoteIssueLink> result = new ArrayList<RemoteIssueLink>();
        for (RemoteIssueLink remoteIssueLink : this.remoteIssueLinks.values()) {
            if (!issue.getId().equals(remoteIssueLink.getIssueId())) continue;
            result.add(remoteIssueLink);
        }
        return result;
    }

    public List<RemoteIssueLink> getRemoteIssueLinksByGlobalId(Issue issue, String globalId) {
        ArrayList<RemoteIssueLink> result = new ArrayList<RemoteIssueLink>();
        for (RemoteIssueLink remoteIssueLink : this.getRemoteIssueLinksForIssue(issue)) {
            if (!globalId.equals(remoteIssueLink.getGlobalId())) continue;
            result.add(remoteIssueLink);
        }
        return result;
    }

    public List<RemoteIssueLink> findRemoteIssueLinksByGlobalIds(Collection<String> globalIds) {
        if (globalIds == null) {
            return ImmutableList.of();
        }
        ArrayList result = Lists.newArrayListWithExpectedSize((int)globalIds.size());
        ImmutableSet globalIdSet = ImmutableSet.copyOf(globalIds);
        for (RemoteIssueLink remoteIssueLink : this.remoteIssueLinks.values()) {
            if (!globalIdSet.contains(remoteIssueLink.getGlobalId())) continue;
            result.add(remoteIssueLink);
        }
        return result;
    }

    public RemoteIssueLink createRemoteIssueLink(RemoteIssueLink remoteIssueLink) {
        RemoteIssueLink linkToStore = this.createBuilder(remoteIssueLink).id(Long.valueOf(this.getNextId())).build();
        this.remoteIssueLinks.put(linkToStore.getId(), linkToStore);
        return linkToStore;
    }

    public void updateRemoteIssueLink(RemoteIssueLink remoteIssueLink) {
        this.remoteIssueLinks.put(remoteIssueLink.getId(), remoteIssueLink);
    }

    public void removeRemoteIssueLink(Long remoteIssueLinkId) {
        this.remoteIssueLinks.remove(remoteIssueLinkId);
    }

    public long getTotalRemoteIssueLinkCountByGlobalId(final String globalId) {
        if (globalId != null) {
            return Iterables.size((Iterable)Iterables.filter(this.remoteIssueLinks.values(), (Predicate)new Predicate<RemoteIssueLink>(){

                public boolean apply(@Nullable RemoteIssueLink ril) {
                    return globalId.equals(ril.getGlobalId());
                }
            }));
        }
        return Iterables.size((Iterable)Iterables.filter(this.remoteIssueLinks.values(), (Predicate)new Predicate<RemoteIssueLink>(){

            public boolean apply(@Nullable RemoteIssueLink ril) {
                return ril.getGlobalId() == null;
            }
        }));
    }

    private RemoteIssueLinkBuilder createBuilder(RemoteIssueLink remoteIssueLink) {
        return new RemoteIssueLinkBuilder(remoteIssueLink);
    }

    private synchronized long getNextId() {
        ++this.nextId;
        return this.nextId;
    }
}

