/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.junit.rules;

import com.atlassian.jira.cache.request.RequestCacheController;
import com.atlassian.jira.component.ComponentAccessor;
import com.atlassian.jira.database.DatabaseSchema;
import com.atlassian.jira.issue.index.DefaultIndexManager;
import com.atlassian.jira.ofbiz.DefaultOfBizConnectionFactory;
import com.atlassian.jira.security.JiraAuthenticationContextImpl;
import com.atlassian.jira.util.JiraKeyUtils;
import java.lang.reflect.Field;
import org.junit.rules.TestWatcher;
import org.junit.runner.Description;
import webwork.config.Configuration;

public class ClearStatics
extends TestWatcher {
    protected void finished(Description description) {
        ClearStatics.clearStatics();
    }

    protected void starting(Description description) {
        ClearStatics.clearStatics();
    }

    private static void clearStatics() {
        ComponentAccessor.initialiseWorker(null);
        DefaultOfBizConnectionFactory.getInstance().resetInstance();
        DatabaseSchema.reset();
        JiraAuthenticationContextImpl.clearRequestCache();
        while (RequestCacheController.isInContext()) {
            RequestCacheController.closeContext();
        }
        DefaultIndexManager.flushThreadLocalSearchers();
        JiraKeyUtils.resetKeyMatcher();
        DatabaseSchema.reset();
        try {
            Field field = Configuration.class.getDeclaredField("configurationImpl");
            field.setAccessible(true);
            field.set(Configuration.class, null);
        }
        catch (NoSuchFieldException e) {
            throw new AssertionError((Object)e);
        }
        catch (IllegalAccessException e) {
            throw new AssertionError((Object)e);
        }
    }
}

