/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.license;

import com.atlassian.application.api.ApplicationKey;
import com.atlassian.extras.api.LicenseType;
import com.atlassian.jira.license.DefaultLicenseDetails;
import com.atlassian.jira.license.LicenseDetails;
import com.atlassian.jira.license.LicensedApplications;
import com.google.common.collect.Maps;
import java.util.Date;
import java.util.Map;
import org.mockito.Matchers;
import org.mockito.Mockito;

public class MockLicenseDetailsBuilder {
    private String rawLicense;
    private String description;
    private Map<ApplicationKey, ApplicationRoleHolder> applicationSeatMap = Maps.newHashMap();
    private LicenseType licenseType;
    private boolean isMaintenanceValidForBuildDate = true;
    private boolean isDataCentreLicense = false;
    private boolean isEvaulationLicense = false;

    public MockLicenseDetailsBuilder setApplicationRoleWithLimit(ApplicationKey key, int userLimit) {
        if (this.applicationSeatMap.containsKey(key)) {
            throw new IllegalArgumentException("Application [" + key + "] already used in mock");
        }
        ApplicationRoleHolder applicationRoleHolder = new ApplicationRoleHolder().setKey(key).setUserLimit(userLimit);
        this.applicationSeatMap.put(key, applicationRoleHolder);
        return this;
    }

    public MockLicenseDetailsBuilder setRawLicense(String rawLicense) {
        if (this.rawLicense != null) {
            throw new IllegalArgumentException("Already have a raw license");
        }
        this.rawLicense = rawLicense;
        return this;
    }

    public MockLicenseDetailsBuilder setDescription(String description) {
        this.description = description;
        return this;
    }

    public MockLicenseDetailsBuilder setLicenseType(LicenseType licenseType) {
        this.licenseType = licenseType;
        return this;
    }

    public MockLicenseDetailsBuilder setAsDataCenter(boolean isDataCentreLicense) {
        this.isDataCentreLicense = isDataCentreLicense;
        return this;
    }

    public MockLicenseDetailsBuilder setAsEvaluationLicense(boolean isEvaulationLicense) {
        this.isEvaulationLicense = isEvaulationLicense;
        return this;
    }

    public LicenseDetails build() {
        LicenseDetails mockLicenseDetails = (LicenseDetails)Mockito.mock(LicenseDetails.class);
        if (this.rawLicense != null) {
            Mockito.when((Object)mockLicenseDetails.getLicenseString()).thenReturn((Object)this.rawLicense);
        }
        if (this.description != null) {
            Mockito.when((Object)mockLicenseDetails.getDescription()).thenReturn((Object)this.description);
        }
        LicensedApplications licensedApplications = (LicensedApplications)Mockito.mock(LicensedApplications.class);
        Mockito.when((Object)mockLicenseDetails.getLicensedApplications()).thenReturn((Object)licensedApplications);
        if (!this.applicationSeatMap.isEmpty()) {
            Mockito.when((Object)licensedApplications.getKeys()).thenReturn(this.applicationSeatMap.keySet());
            for (ApplicationRoleHolder applicationRoleHolder : this.applicationSeatMap.values()) {
                Mockito.when((Object)licensedApplications.getUserLimit(applicationRoleHolder.key)).thenReturn((Object)applicationRoleHolder.userLimit);
            }
        }
        Mockito.when((Object)mockLicenseDetails.hasApplication((ApplicationKey)Matchers.any(ApplicationKey.class))).thenAnswer(invoc -> this.applicationSeatMap.containsKey((ApplicationKey)invoc.getArguments()[0]));
        Mockito.when((Object)mockLicenseDetails.getLicenseVersion()).thenReturn((Object)2);
        if (this.licenseType != null) {
            Mockito.when((Object)mockLicenseDetails.getLicenseType()).thenReturn((Object)this.licenseType);
            if (this.licenseType == LicenseType.STARTER) {
                Mockito.when((Object)mockLicenseDetails.isStarter()).thenReturn((Object)true);
            }
            if (DefaultLicenseDetails.PAID_LICENSE_TYPES.contains(this.licenseType)) {
                Mockito.when((Object)mockLicenseDetails.isPaidType()).thenReturn((Object)true);
            }
        } else {
            Mockito.when((Object)mockLicenseDetails.getLicenseType()).thenReturn((Object)LicenseType.COMMERCIAL);
        }
        Mockito.when((Object)mockLicenseDetails.isMaintenanceValidForBuildDate((Date)Matchers.any())).thenReturn((Object)this.isMaintenanceValidForBuildDate);
        Mockito.when((Object)mockLicenseDetails.isDataCenter()).thenReturn((Object)this.isDataCentreLicense);
        Mockito.when((Object)mockLicenseDetails.isEvaluation()).thenReturn((Object)this.isEvaulationLicense);
        return mockLicenseDetails;
    }

    public MockLicenseDetailsBuilder isMaintenanceValidForBuildDate(boolean isMaintenanceValidForBuildDate) {
        this.isMaintenanceValidForBuildDate = isMaintenanceValidForBuildDate;
        return this;
    }

    private static class ApplicationRoleHolder {
        private ApplicationKey key;
        private int userLimit = 0;

        private ApplicationRoleHolder() {
        }

        public ApplicationRoleHolder setKey(ApplicationKey key) {
            this.key = key;
            return this;
        }

        public ApplicationRoleHolder setUserLimit(int userLimit) {
            this.userLimit = userLimit;
            return this;
        }
    }
}

