/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.license;

import com.atlassian.extras.api.LicenseException;
import com.atlassian.jira.license.LicenseDetails;
import com.atlassian.jira.license.LicenseDetailsFactory;
import com.atlassian.jira.license.MockLicenseDetails;
import com.google.common.collect.Maps;
import java.util.Map;
import java.util.function.Function;
import javax.annotation.Nonnull;

public class MockLicenseDetailsFactory
implements LicenseDetailsFactory {
    private Map<String, MockLicenseDetails> details = Maps.newHashMap();
    private Function<String, MockLicenseDetails> defaultFunction = MockLicenseDetailsFactory::throwError;

    @Nonnull
    public LicenseDetails getLicense(@Nonnull String licenseString) throws LicenseException {
        MockLicenseDetails localDetails = this.details.get(licenseString);
        if (localDetails != null) {
            return localDetails;
        }
        return this.defaultFunction.apply(licenseString);
    }

    public boolean isDecodeable(@Nonnull String licenseString) {
        return this.details.containsKey(licenseString);
    }

    public MockLicenseDetailsFactory byDefaultReturnLicense() {
        this.defaultFunction = MockLicenseDetailsFactory::alwaysWork;
        return this;
    }

    public MockLicenseDetailsFactory byDefaultThrowError() {
        this.defaultFunction = MockLicenseDetailsFactory::throwError;
        return this;
    }

    private static MockLicenseDetails alwaysWork(String licenseString) {
        return new MockLicenseDetails().setLicenseString(licenseString);
    }

    private static MockLicenseDetails throwError(String licenseString) {
        throw new LicenseException(String.format("'%s' is not a valid license.", licenseString));
    }

    public MockLicenseDetails addLicense(String license) {
        MockLicenseDetails newLicense = new MockLicenseDetails();
        this.details.put(license, newLicense);
        return newLicense.setLicenseString(license);
    }
}

