/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.local.runner;

import com.atlassian.jira.local.listener.StatsGatheringRunListener;
import java.lang.annotation.Annotation;
import java.util.concurrent.atomic.AtomicBoolean;
import junit.framework.TestCase;
import org.junit.runner.Description;
import org.junit.runner.Result;
import org.junit.runner.notification.Failure;
import org.junit.runner.notification.RunListener;
import org.junit.runner.notification.RunNotifier;
import org.junit.runner.notification.StoppedByUserException;

public class GlobalRunNotifier
extends RunNotifier {
    private static GlobalRunNotifier INSTANCE = new GlobalRunNotifier();
    private static AtomicBoolean SUITE_STARTED = new AtomicBoolean(false);
    private static AtomicBoolean SUITE_ENDED = new AtomicBoolean(false);
    private Result result = new Result();

    public static GlobalRunNotifier getInstance() {
        return INSTANCE;
    }

    private static void handleJVMShutdown() {
        Runtime.getRuntime().addShutdownHook(new Thread(){

            @Override
            public void run() {
                INSTANCE.fireTestRunFinished(INSTANCE.getResult());
            }
        });
    }

    public Result getResult() {
        return this.result;
    }

    public void fireTestRunStarted(Description description) {
        if (SUITE_STARTED.compareAndSet(false, true)) {
            super.fireTestRunStarted(description);
        }
    }

    public void fireTestRunFinished(Result result) {
        if (SUITE_ENDED.compareAndSet(false, true)) {
            super.fireTestRunFinished(result);
        }
    }

    public void fireTestStarted(Description description) throws StoppedByUserException {
        if (!SUITE_STARTED.get()) {
            this.fireTestRunStarted(Description.createSuiteDescription((String)"JIRA Unit Tests", (Annotation[])new Annotation[0]));
        }
        super.fireTestStarted(description);
    }

    public void fireTestStarted(TestCase test) throws StoppedByUserException {
        this.fireTestStarted(this.toDesc(test));
    }

    public void fireTestFailure(TestCase test, Throwable thrownException) {
        this.fireTestFailure(new Failure(this.toDesc(test), thrownException));
    }

    public void fireTestFinished(TestCase test) {
        this.fireTestFinished(this.toDesc(test));
    }

    private Description toDesc(TestCase test) {
        return Description.createTestDescription(test.getClass(), (String)test.getName());
    }

    static {
        INSTANCE.addListener(INSTANCE.getResult().createListener());
        INSTANCE.addListener(new TestRunStartedListener());
        INSTANCE.addListener(new StatsGatheringRunListener());
        GlobalRunNotifier.handleJVMShutdown();
    }

    private static class TestRunStartedListener
    extends RunListener {
        private TestRunStartedListener() {
        }

        public void testRunStarted(Description description) throws Exception {
            INSTANCE.fireTestRunStarted(description);
        }
    }
}

