/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.local.testutils;

import com.atlassian.core.ofbiz.CoreFactory;
import com.atlassian.core.ofbiz.util.CoreTransactionUtil;
import com.atlassian.jira.config.database.DatabaseConfig;
import com.atlassian.jira.config.database.Datasource;
import com.atlassian.jira.config.database.JdbcDatasource;
import java.util.Collection;
import java.util.Collections;
import org.ofbiz.core.entity.GenericDelegator;
import org.ofbiz.core.entity.GenericEntityException;
import org.ofbiz.core.entity.model.ModelEntity;
import org.ofbiz.core.entity.model.ModelReader;
import org.ofbiz.core.entity.model.ModelViewEntity;

public class UtilsForTestSetup {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void deleteAllEntities() throws GenericEntityException {
        CoreTransactionUtil.setUseTransactions((boolean)true);
        boolean beganTransaction = CoreTransactionUtil.begin();
        try {
            GenericDelegator delegator = CoreFactory.getGenericDelegator();
            ModelReader reader = delegator.getModelReader();
            Collection entityNames = reader.getEntityNames();
            for (String entityName : entityNames) {
                ModelEntity modelEntity = delegator.getModelReader().getModelEntity(entityName);
                if (modelEntity instanceof ModelViewEntity) continue;
                delegator.removeByAnd(entityName, Collections.emptyMap());
            }
        }
        finally {
            CoreTransactionUtil.commit((boolean)beganTransaction);
        }
    }

    public static DatabaseConfig getDatabaseConfig() {
        JdbcDatasource datasource = new JdbcDatasource("jdbc:h2:mem:h2db", "org.h2.Driver", "sa", "", 10, null, Long.valueOf(4000L), Long.valueOf(5000L));
        return new DatabaseConfig("h2", "PUBLIC", (Datasource)datasource);
    }
}

