/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.matchers;

import com.atlassian.jira.matchers.LangMatchers;
import com.google.common.base.Function;
import org.hamcrest.Description;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.hamcrest.SelfDescribing;
import org.hamcrest.TypeSafeMatcher;
import org.junit.runners.model.InitializationError;

public final class ErrorMatchers {
    private ErrorMatchers() {
        throw new AssertionError((Object)"Don't instantiate me");
    }

    public static Matcher<Throwable> withMessage(String ... expectedSubstrings) {
        return ErrorMatchers.withMessage(LangMatchers.containsInOrder(expectedSubstrings));
    }

    public static Matcher<Throwable> withMessage(final Matcher<String> messageMatcher) {
        return new TypeSafeMatcher<Throwable>(){

            public boolean matchesSafely(Throwable throwable) {
                return messageMatcher.matches((Object)throwable.getMessage());
            }

            public void describeTo(Description description) {
                description.appendText("a Throwable with message ").appendDescriptionOf((SelfDescribing)messageMatcher);
            }
        };
    }

    public static Matcher<Throwable> withCause(Class<? extends Throwable> causeType) {
        return ErrorMatchers.withCause(LangMatchers.isInstance(causeType));
    }

    public static Matcher<Throwable> withCause(final Matcher<? extends Throwable> causeMatcher) {
        return new TypeSafeMatcher<Throwable>(){

            public boolean matchesSafely(Throwable throwable) {
                return causeMatcher.matches((Object)throwable.getCause());
            }

            public void describeTo(Description description) {
                description.appendText("a Throwable with cause (").appendDescriptionOf((SelfDescribing)causeMatcher).appendText(")");
            }
        };
    }

    public static <T extends Throwable> Matcher<Throwable> specificError(final Class<T> errorClass, final Matcher<T> specificMatcher) {
        return new TypeSafeMatcher<Throwable>(){

            public boolean matchesSafely(Throwable throwable) {
                return Matchers.instanceOf((Class)errorClass).matches((Object)throwable) && specificMatcher.matches(errorClass.cast(throwable));
            }

            public void describeTo(Description description) {
                description.appendText("an instance of ").appendValue((Object)errorClass).appendText(" that is (").appendDescriptionOf((SelfDescribing)specificMatcher).appendText(")");
            }
        };
    }

    public static Matcher<InitializationError> withCauses(final Matcher<Iterable<Throwable>> causesMatcher) {
        return new TypeSafeMatcher<InitializationError>(){

            public boolean matchesSafely(InitializationError initializationError) {
                return causesMatcher.matches((Object)initializationError.getCauses());
            }

            public void describeTo(Description description) {
                description.appendText("a JUnit InitializationError with causes ").appendDescriptionOf((SelfDescribing)causesMatcher);
            }
        };
    }

    public static <T, U> Matcher<T> withTransformed(final Matcher<U> valueMatcher, final Function<T, U> transformer) {
        return new TypeSafeMatcher<T>(){

            protected boolean matchesSafely(T item) {
                return valueMatcher.matches(transformer.apply(item));
            }

            public void describeTo(Description description) {
                description.appendText("an Object transformed that matches ").appendDescriptionOf((SelfDescribing)valueMatcher);
            }
        };
    }
}

