/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.matchers;

import com.atlassian.jira.issue.Issue;
import com.atlassian.jira.util.dbc.Assertions;
import org.hamcrest.Description;
import org.hamcrest.Matcher;
import org.hamcrest.TypeSafeMatcher;

public final class IssueMatchers {
    private IssueMatchers() {
        throw new AssertionError((Object)"Don't instantiate me");
    }

    public static Matcher<Issue> issueWithId(final Long id) {
        Assertions.notNull((String)"id", (Object)id);
        return new TypeSafeMatcher<Issue>(){

            protected boolean matchesSafely(Issue issue) {
                return id.equals(issue.getId());
            }

            public void describeTo(Description description) {
                description.appendText("Issue with ID=").appendValue((Object)id);
            }
        };
    }

    public static Matcher<Issue> issueWithKey(final String key) {
        Assertions.notNull((String)"key", (Object)key);
        return new TypeSafeMatcher<Issue>(){

            protected boolean matchesSafely(Issue issue) {
                return key.equals(issue.getKey());
            }

            public void describeTo(Description description) {
                description.appendText("Issue with key ").appendValue((Object)key);
            }
        };
    }
}

