/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.matchers;

import org.hamcrest.Description;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.hamcrest.TypeSafeMatcher;

public final class LangMatchers {
    private LangMatchers() {
        throw new AssertionError((Object)"Don't instantiate me");
    }

    public static <T> Matcher<T> isInstance(Class<? extends T> type) {
        return Matchers.instanceOf(type);
    }

    public static Matcher<String> containsInOrder(final CharSequence ... substrings) {
        return new TypeSafeMatcher<String>(){

            public boolean matchesSafely(String item) {
                int index = -1;
                for (CharSequence substring : substrings) {
                    index = item.indexOf(substring.toString(), index);
                    if (index >= 0) continue;
                    return false;
                }
                return true;
            }

            public void describeTo(Description description) {
                description.appendText("a string that contains (in order): ").appendValueList("(", ",", ")", (Object[])substrings);
            }
        };
    }
}

