/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.matchers;

import org.apache.lucene.document.Document;
import org.apache.lucene.document.Fieldable;
import org.hamcrest.FeatureMatcher;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;

public class LuceneDocumentMatchers {
    public static FieldableHasStringValue fieldableHasStringValue(Matcher<? super String> stringValueMatcher) {
        return new FieldableHasStringValue(stringValueMatcher);
    }

    public static DocumentFieldMatcher hasStringFieldThat(String fieldName, Matcher<Fieldable> expectedValue) {
        return new DocumentFieldMatcher(fieldName, expectedValue);
    }

    public static DocumentFieldMatcher hasStringField(String fieldName, String expectedValue) {
        Matcher string = Matchers.equalTo((Object)expectedValue);
        return LuceneDocumentMatchers.hasStringFieldThat(fieldName, (Matcher<Fieldable>)LuceneDocumentMatchers.fieldableHasStringValue((Matcher<? super String>)string));
    }

    public static class FieldableHasStringValue
    extends FeatureMatcher<Fieldable, String> {
        public FieldableHasStringValue(Matcher<? super String> subMatcher) {
            super(subMatcher, "field with a value", "string value");
        }

        protected String featureValueOf(Fieldable actual) {
            return actual.stringValue();
        }
    }

    public static class DocumentFieldMatcher
    extends FeatureMatcher<Document, Fieldable> {
        private final String fieldName;

        public DocumentFieldMatcher(String fieldName, Matcher<? super Fieldable> fieldMatcher) {
            super(fieldMatcher, "a document with a field \"" + fieldName + "\"", fieldName);
            this.fieldName = fieldName;
        }

        protected Fieldable featureValueOf(Document actual) {
            return actual.getFieldable(this.fieldName);
        }
    }
}

