/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.matchers;

import com.google.common.collect.Sets;
import java.util.Set;
import org.hamcrest.Description;
import org.hamcrest.Matcher;
import org.hamcrest.TypeSafeDiagnosingMatcher;

public final class SetMatchers {
    private SetMatchers() {
    }

    public static <T> Matcher<Set<T>> subsetOf(final Set<T> superSet) {
        return new TypeSafeDiagnosingMatcher<Set<T>>(){

            protected boolean matchesSafely(Set<T> item, Description mismatchDescription) {
                if (superSet.containsAll(item)) {
                    return true;
                }
                Sets.SetView badItems = Sets.difference(item, (Set)superSet);
                mismatchDescription.appendValue((Object)String.format("but contained extra items %s.", badItems));
                return false;
            }

            public void describeTo(Description description) {
                description.appendValue((Object)String.format("Subset of %s", superSet));
            }
        };
    }
}

