/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.matchers.johnson;

import com.atlassian.jira.util.dbc.Assertions;
import com.atlassian.johnson.event.Event;
import org.hamcrest.Description;
import org.hamcrest.Matcher;
import org.hamcrest.TypeSafeDiagnosingMatcher;

public final class JohnsonEventMatchers {
    private JohnsonEventMatchers() {
        throw new AssertionError((Object)"Don't instantiate me");
    }

    public static Matcher<Event> hasKey(final String key) {
        Assertions.notNull((String)"key", (Object)key);
        return new TypeSafeDiagnosingMatcher<Event>(){

            protected boolean matchesSafely(Event item, Description mismatchDescription) {
                return key.equals(item.getKey().getType());
            }

            public void describeTo(Description description) {
                description.appendText("A Johnson Event with a key ").appendValue((Object)key);
            }
        };
    }

    public static Matcher<Event> hasDescription(final String eventDescription) {
        Assertions.notNull((String)"description", (Object)eventDescription);
        return new TypeSafeDiagnosingMatcher<Event>(){

            protected boolean matchesSafely(Event item, Description mismatchDescription) {
                if (!eventDescription.equals(item.getDesc())) {
                    mismatchDescription.appendValue((Object)"Expected description ").appendValue((Object)eventDescription).appendText(" but was ").appendValue((Object)item.getDesc());
                    return false;
                }
                return true;
            }

            public void describeTo(Description description) {
                description.appendText("A Johnson Event with a description ").appendValue((Object)eventDescription);
            }
        };
    }

    public static Matcher<Event> containsDescription(final String eventDescription) {
        Assertions.notNull((String)"description", (Object)eventDescription);
        return new TypeSafeDiagnosingMatcher<Event>(){

            protected boolean matchesSafely(Event item, Description mismatchDescription) {
                if (item.getDesc() == null || !item.getDesc().contains(eventDescription)) {
                    mismatchDescription.appendValue((Object)"Expected to contain description ").appendValue((Object)eventDescription).appendText(" but was ").appendValue((Object)item.getDesc());
                    return false;
                }
                return true;
            }

            public void describeTo(Description description) {
                description.appendText("A Johnson Event containing a description ").appendValue((Object)eventDescription);
            }
        };
    }

    public static Matcher<Event> hasLevel(final String level) {
        Assertions.notNull((String)"level", (Object)level);
        return new TypeSafeDiagnosingMatcher<Event>(){

            protected boolean matchesSafely(Event item, Description mismatchDescription) {
                return level.equals(item.getLevel().getLevel());
            }

            public void describeTo(Description description) {
                description.appendText("A Johnson Event with a level ").appendValue((Object)level);
            }
        };
    }
}

