/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.mock;

import com.atlassian.jira.avatar.Avatar;
import com.atlassian.jira.icon.IconType;
import com.atlassian.jira.plugin.icon.IssueTypeIconTypePolicy;
import com.atlassian.jira.plugin.icon.ProjectIconTypePolicy;
import com.atlassian.jira.plugin.icon.UserIconTypePolicy;
import javax.annotation.Nonnull;
import org.mockito.Mockito;

public class MockAvatar
implements Avatar {
    private long id;
    private IconType iconType;
    private String contentType;
    private String fileName;
    private String owner;
    private boolean system;

    public MockAvatar(long id, String fileName, String contentType, IconType iconType, String owner, boolean system) {
        this.id = id;
        this.contentType = contentType;
        this.fileName = fileName;
        this.owner = owner;
        this.system = system;
        this.iconType = iconType;
    }

    @Deprecated
    public MockAvatar(long id, String fileName, String contentType, Avatar.Type type, String owner, boolean system) {
        this(id, fileName, contentType, (IconType)null, owner, system);
        IconType iconType;
        switch (type) {
            case USER: {
                UserIconTypePolicy uPolicy = (UserIconTypePolicy)Mockito.mock(UserIconTypePolicy.class);
                iconType = IconType.USER_ICON_TYPE;
                break;
            }
            case PROJECT: {
                ProjectIconTypePolicy pPolicy = (ProjectIconTypePolicy)Mockito.mock(ProjectIconTypePolicy.class);
                iconType = IconType.PROJECT_ICON_TYPE;
                break;
            }
            case ISSUETYPE: {
                IssueTypeIconTypePolicy iPolicy = (IssueTypeIconTypePolicy)Mockito.mock(IssueTypeIconTypePolicy.class);
                iconType = IconType.ISSUE_TYPE_ICON_TYPE;
                break;
            }
            default: {
                iconType = null;
            }
        }
        this.iconType = iconType;
    }

    public Avatar.Type getAvatarType() {
        if (Avatar.Type.supportsName((String)this.iconType.getKey())) {
            return Avatar.Type.getByName((String)this.iconType.getKey());
        }
        return Avatar.Type.OTHER;
    }

    @Nonnull
    public IconType getIconType() {
        return this.iconType;
    }

    public String getContentType() {
        return this.contentType;
    }

    public String getFileName() {
        return this.fileName;
    }

    public Long getId() {
        return this.id;
    }

    public String getOwner() {
        return this.owner;
    }

    public boolean isSystemAvatar() {
        return this.system;
    }
}

