/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.mock;

import com.atlassian.collectors.CollectorsUtil;
import com.atlassian.fugue.Option;
import com.atlassian.jira.config.ConstantsManager;
import com.atlassian.jira.exception.CreateException;
import com.atlassian.jira.exception.RemoveException;
import com.atlassian.jira.issue.IssueConstant;
import com.atlassian.jira.issue.issuetype.IssueType;
import com.atlassian.jira.issue.issuetype.IssueTypeImpl;
import com.atlassian.jira.issue.priority.Priority;
import com.atlassian.jira.issue.resolution.Resolution;
import com.atlassian.jira.issue.status.Status;
import com.atlassian.jira.issue.status.StatusImpl;
import com.atlassian.jira.mock.ofbiz.MockGenericValue;
import com.atlassian.jira.ofbiz.FieldMap;
import com.atlassian.jira.util.ErrorCollection;
import com.atlassian.jira.util.lang.Pair;
import com.google.common.collect.Maps;
import com.google.common.collect.Ordering;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.ofbiz.core.entity.GenericValue;

public class MockConstantsManager
implements ConstantsManager {
    Map<String, IssueType> issueTypes = Maps.newHashMap();
    Map<String, Priority> priorities = Maps.newHashMap();
    Map<String, Resolution> resolutions = Maps.newHashMap();
    Map<String, Status> statuses = Maps.newHashMap();

    public Status getStatus(String id) {
        return this.statuses.get(id);
    }

    @Nonnull
    public Collection<Status> getStatuses() {
        return this.statuses.values();
    }

    public void refreshStatuses() {
        throw new UnsupportedOperationException();
    }

    @Nullable
    public List<IssueConstant> convertToConstantObjects(String constantType, Collection<?> ids) {
        return null;
    }

    public boolean constantExists(String constantType, String name) {
        return false;
    }

    public IssueType insertIssueType(String name, Long sequence, String style, String description, String iconurl) {
        Long id = MockConstantsManager.findNextIdFor(this.issueTypes);
        MockGenericValue issueType = new MockGenericValue("IssueType", (Map<String, ?>)FieldMap.build((String)"id", (Object)id).add("name", (Object)name).add("sequence", (Object)sequence).add("style", (Object)style).add("description", (Object)description).add("iconurl", (Object)iconurl));
        this.addIssueType(issueType);
        return new IssueTypeImpl((GenericValue)issueType, null, null, null, null);
    }

    public IssueType insertIssueType(String name, Long sequence, String style, String description, Long avatarId) throws CreateException {
        Long id = MockConstantsManager.findNextIdFor(this.issueTypes);
        MockGenericValue issueType = new MockGenericValue("IssueType", (Map<String, ?>)FieldMap.build((String)"id", (Object)id).add("name", (Object)name).add("sequence", (Object)sequence).add("style", (Object)style).add("description", (Object)description).add("avatar", (Object)avatarId));
        this.addIssueType(issueType);
        return new IssueTypeImpl((GenericValue)issueType, null, null, null, null);
    }

    private static Long findNextIdFor(Map<String, ? extends IssueConstant> issueTypes) {
        long maxId = 0L;
        for (IssueConstant issueConstant : issueTypes.values()) {
            Long id = Long.valueOf(issueConstant.getId());
            if (id <= maxId) continue;
            maxId = id;
        }
        return maxId + 1L;
    }

    public void validateCreateIssueType(String name, String style, String description, String iconurl, ErrorCollection errors, String nameFieldName) {
    }

    public void validateCreateIssueTypeWithAvatar(String name, String style, String description, String avatarId, ErrorCollection errors, String nameFieldName) {
    }

    public void updateIssueType(String id, String name, Long sequence, String style, String description, String iconurl) {
        throw new UnsupportedOperationException();
    }

    public void updateIssueType(String id, String name, Long sequence, String style, String description, Long avatarId) {
        throw new UnsupportedOperationException();
    }

    public void removeIssueType(String id) throws RemoveException {
    }

    public IssueConstant getConstantByNameIgnoreCase(String constantType, String name) {
        return null;
    }

    public IssueConstant getIssueConstantByName(String constantType, String name) {
        return null;
    }

    public List<IssueType> getEditableSubTaskIssueTypes() {
        return Collections.emptyList();
    }

    public List<String> getAllIssueTypeIds() {
        return Collections.emptyList();
    }

    public IssueConstant getIssueConstant(GenericValue issueConstantGV) {
        throw new UnsupportedOperationException("Not implemented.");
    }

    public void storeIssueTypes(List<GenericValue> issueTypes) {
        throw new UnsupportedOperationException();
    }

    public void refresh() {
        throw new UnsupportedOperationException();
    }

    public Option<Pair<String, ErrorCollection.Reason>> validateName(String name, Option<IssueType> issueType) {
        return Option.none();
    }

    public void invalidateAll() {
        throw new UnsupportedOperationException();
    }

    public void invalidate(IssueConstant issueConstant) {
        throw new UnsupportedOperationException("Not implemented");
    }

    public List<String> expandIssueTypeIds(Collection<String> issueTypeIds) {
        if (issueTypeIds == null) {
            return Collections.emptyList();
        }
        for (String issueTypeId : issueTypeIds) {
            if ("-2".equals(issueTypeId)) {
                return MockConstantsManager.getConstantIds(this.getRegularIssueTypeObjects());
            }
            if ("-3".equals(issueTypeId)) {
                return MockConstantsManager.getConstantIds(this.getSubTaskIssueTypeObjects());
            }
            if (!"-4".equals(issueTypeId)) continue;
            return this.getAllIssueTypeIds();
        }
        return new ArrayList<String>(issueTypeIds);
    }

    @Nonnull
    public Collection<Priority> getPriorities() {
        ArrayList<Priority> priorityList = new ArrayList<Priority>(this.priorities.values());
        return Ordering.from((Comparator)new Comparator<IssueConstant>(){

            @Override
            public int compare(IssueConstant issueConstant, IssueConstant t1) {
                return issueConstant.getSequence().compareTo(t1.getSequence());
            }
        }).immutableSortedCopy(priorityList);
    }

    public String getPriorityName(String id) {
        return null;
    }

    public Priority getPriorityObject(String id) {
        throw new UnsupportedOperationException("Not implemented.");
    }

    public Priority getDefaultPriority() {
        return null;
    }

    public Priority getDefaultPriorityObject() {
        return null;
    }

    public void refreshPriorities() {
        throw new UnsupportedOperationException();
    }

    public Collection<Resolution> getResolutions() {
        return this.resolutions.values();
    }

    public Collection<Resolution> getResolutionObjects() {
        return this.getResolutions();
    }

    public Resolution getResolution(String id) {
        return this.resolutions.get(id);
    }

    public Resolution getResolutionObject(String id) {
        return this.getResolution(id);
    }

    public void refreshResolutions() {
        throw new UnsupportedOperationException();
    }

    public IssueType getIssueType(String id) {
        return this.issueTypes.get(id);
    }

    public void refreshIssueTypes() {
        throw new UnsupportedOperationException();
    }

    public IssueConstant getConstantObject(String constantType, String id) {
        throw new UnsupportedOperationException();
    }

    @Nonnull
    public Collection<? extends IssueConstant> getConstantObjects(String constantType) {
        return Collections.emptyList();
    }

    public void addIssueType(GenericValue type) {
        this.issueTypes.put(type.getString("id"), (IssueType)new IssueTypeImpl(type, null, null, null, null));
    }

    public void addIssueType(IssueType type) {
        this.issueTypes.put(type.getId(), type);
    }

    public void addStatus(GenericValue status) {
        this.statuses.put(status.getString("id"), (Status)new StatusImpl(status, null, null, null, null));
    }

    public Collection<IssueType> getAllIssueTypeObjects() {
        return this.issueTypes.values();
    }

    public Collection<IssueType> getRegularIssueTypeObjects() {
        return this.issueTypes.values().stream().filter(issueType -> !issueType.isSubTask()).collect(Collectors.toList());
    }

    @Nonnull
    public Collection<IssueType> getSubTaskIssueTypeObjects() {
        return this.issueTypes.values().stream().filter(IssueType::isSubTask).collect(Collectors.toList());
    }

    public Status getStatusByName(String name) {
        return null;
    }

    public Status getStatusByNameIgnoreCase(String name) {
        return null;
    }

    public Status getStatusByTranslatedName(String name) {
        return null;
    }

    @Nonnull
    public List<IssueConstant> getConstantsByIds(@Nonnull ConstantsManager.CONSTANT_TYPE constantType, @Nonnull Collection<String> ids) {
        if (constantType == ConstantsManager.CONSTANT_TYPE.ISSUE_TYPE) {
            return this.getAllIssueTypeObjects().stream().filter(issueType -> ids.contains(issueType.getId())).collect(Collectors.toList());
        }
        throw new UnsupportedOperationException("Not implemented");
    }

    public void recalculateIssueTypeSequencesAndStore(List<IssueType> issueTypes) {
        throw new UnsupportedOperationException("Not implemented");
    }

    public void recalculatePrioritySequencesAndStore(List<Priority> priorities) {
        throw new UnsupportedOperationException("Not implemented");
    }

    public void recalculateStatusSequencesAndStore(List<Status> statuses) {
        throw new UnsupportedOperationException("Not implemented");
    }

    public void recalculateResolutionSequencesAndStore(List<Resolution> resolutions) {
        throw new UnsupportedOperationException("Not implemented");
    }

    private static <T extends IssueConstant> List<String> getConstantIds(Collection<T> constants) {
        return (List)constants.stream().map(IssueConstant::getId).collect(CollectorsUtil.toNewArrayListWithSizeOf(constants));
    }
}

