/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.mock;

import com.atlassian.fugue.Option;
import com.atlassian.jira.config.CoreFeatures;
import com.atlassian.jira.config.Feature;
import com.atlassian.jira.config.FeatureFlag;
import com.atlassian.jira.config.FeatureManager;
import com.atlassian.jira.plugin.profile.DarkFeatures;
import com.atlassian.jira.user.ApplicationUser;
import com.google.common.collect.Sets;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import javax.annotation.Nullable;

public class MockFeatureManager
implements FeatureManager {
    private DarkFeatures darkFeatures = new DarkFeatures(Collections.emptySet(), Collections.emptySet(), Collections.emptySet());
    private Set<String> enabledFeatures = new HashSet<String>();

    public boolean isEnabled(String featureKey) {
        return this.enabledFeatures.contains(featureKey);
    }

    public boolean isEnabled(Feature feature) {
        return this.isEnabled(feature.featureKey());
    }

    public boolean isEnabled(FeatureFlag featureFlag) {
        return this.isEnabled(featureFlag.enabledFeatureKey());
    }

    public Option<FeatureFlag> getFeatureFlag(String featureKey) {
        return Option.none();
    }

    public boolean isEnabled(CoreFeatures feature) {
        return this.isEnabled(feature.featureKey());
    }

    public void enable(CoreFeatures feature) {
        this.enabledFeatures.add(feature.featureKey());
    }

    public void enable(Feature feature) {
        this.enabledFeatures.add(feature.featureKey());
    }

    public MockFeatureManager disable(Feature feature) {
        this.enabledFeatures.remove(feature.featureKey());
        return this;
    }

    public Set<String> getEnabledFeatureKeys() {
        return this.enabledFeatures;
    }

    public DarkFeatures getDarkFeatures() {
        return this.darkFeatures;
    }

    public Set<FeatureFlag> getRegisteredFlags() {
        HashSet flags = Sets.newHashSet();
        for (String s : this.enabledFeatures) {
            flags.add(FeatureFlag.featureFlag((String)s));
        }
        return flags;
    }

    public void enableUserDarkFeature(ApplicationUser user, String feature) {
        this.darkFeatures.getUserEnabledFeatures().add(feature);
    }

    public void disableUserDarkFeature(ApplicationUser user, String feature) {
        this.darkFeatures.getUserEnabledFeatures().remove(feature);
    }

    public void enableSiteDarkFeature(String feature) {
        this.darkFeatures.getSiteEnabledFeatures().add(feature);
    }

    public void disableSiteDarkFeature(String feature) {
        this.darkFeatures.getSiteEnabledFeatures().remove(feature);
    }

    public boolean hasSiteEditPermission() {
        return true;
    }

    public DarkFeatures getDarkFeaturesForUser(@Nullable ApplicationUser user) {
        return this.getDarkFeatures();
    }

    public boolean isEnabledForUser(ApplicationUser user, String featureKey) {
        return this.isEnabled(featureKey);
    }

    public static class AllDarkFeaturesDisabled {
        public static MockFeatureManager get() {
            return new MockFeatureManager();
        }
    }
}

