/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.mock;

import com.atlassian.jira.bc.project.ProjectCreationData;
import com.atlassian.jira.exception.DataAccessException;
import com.atlassian.jira.exception.RemoveException;
import com.atlassian.jira.project.AbstractProjectManager;
import com.atlassian.jira.project.MockProject;
import com.atlassian.jira.project.Project;
import com.atlassian.jira.project.ProjectCategory;
import com.atlassian.jira.project.ProjectCategoryImpl;
import com.atlassian.jira.project.UpdateProjectParameters;
import com.atlassian.jira.project.type.ProjectTypeKey;
import com.atlassian.jira.task.context.Context;
import com.atlassian.jira.user.ApplicationUser;
import com.atlassian.jira.user.MockApplicationUser;
import com.atlassian.jira.util.dbc.Assertions;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.atomic.AtomicInteger;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.ofbiz.core.entity.GenericValue;

public class MockProjectManager
extends AbstractProjectManager {
    private final Map<Long, Project> projects = new HashMap<Long, Project>();
    private final Map<Long, ProjectCategory> projectCategories = new HashMap<Long, ProjectCategory>();
    private final AtomicInteger nextId = new AtomicInteger();
    private long projectCategoryCounter = 100L;

    public MockProjectManager() {
        super(null, null);
    }

    public void addProject(Project project) {
        this.projects.put(project.getId(), project);
    }

    public void addProject(GenericValue gv) {
        Long id = gv.getLong("id");
        this.projects.put(id, new MockProject(id, gv.getString("key"), gv.getString("name"), gv));
    }

    public void removeAllProjects() {
        this.projects.clear();
    }

    public Project createProject(@Nonnull ApplicationUser user, @Nonnull ProjectCreationData projectCreationData) {
        MockProject project = new MockProject((long)this.nextId.addAndGet(1), projectCreationData.getKey(), projectCreationData.getName());
        project.setAssigneeType(projectCreationData.getAssigneeType());
        return project;
    }

    public Project updateProject(Project updatedProject, String name, String description, String leadKey, String url, Long assigneeType, Long avatarId, String projectKey) {
        return this.updateProject(UpdateProjectParameters.forProject((Long)updatedProject.getId()).name(name).description(description).leadUsername(leadKey).url(url).assigneeType(assigneeType).avatarId(avatarId).key(projectKey));
    }

    public Project updateProject(UpdateProjectParameters parameters) {
        Project project = (Project)Assertions.notNull((Object)this.getProjectObj(parameters.getProjectId()));
        MockProject newProject = new MockProject(parameters.getProjectId(), project.getKey(), project.getName());
        if (parameters.getName().isDefined()) {
            newProject.setName((String)parameters.getName().get());
        }
        if (parameters.getDescription().isDefined()) {
            newProject.setDescription((String)parameters.getDescription().get());
        }
        if (parameters.getLeadUsername().isDefined()) {
            newProject.setLead(new MockApplicationUser((String)parameters.getLeadUsername().get()));
        }
        if (parameters.getUrl().isDefined()) {
            newProject.setUrl((String)parameters.getUrl().get());
        }
        if (parameters.getAssigneeType().isDefined()) {
            newProject.setAssigneeType((Long)parameters.getAssigneeType().get());
        }
        if (parameters.getProjectTypeKey().isDefined()) {
            newProject.setProjectTypeKey((String)parameters.getProjectTypeKey().get());
        }
        this.projects.put(newProject.getId(), newProject);
        return newProject;
    }

    public void removeProjectIssues(Project project) throws RemoveException {
        throw new UnsupportedOperationException();
    }

    public void removeProjectIssues(Project project, Context taskContext) throws RemoveException {
        throw new UnsupportedOperationException("Not implemented");
    }

    public void removeProject(Project project) {
        throw new UnsupportedOperationException();
    }

    public Project getProjectObj(Long id) {
        return this.projects.get(id);
    }

    public Project getProjectObjByKey(String projectKey) {
        for (Project project : this.getProjectObjects()) {
            if (!projectKey.equals(project.getKey())) continue;
            return project;
        }
        return null;
    }

    public Project getProjectByCurrentKeyIgnoreCase(String projectKey) {
        for (Project project : this.getProjectObjects()) {
            if (!projectKey.equalsIgnoreCase(project.getKey())) continue;
            return project;
        }
        return null;
    }

    public Project getProjectObjByKeyIgnoreCase(String projectKey) {
        return this.getProjectByCurrentKeyIgnoreCase(projectKey);
    }

    public Set<String> getAllProjectKeys(Long projectId) {
        throw new UnsupportedOperationException("Not implemented");
    }

    public Project getProjectObjByName(String projectName) {
        for (Project project : this.getProjectObjects()) {
            if (!projectName.equals(project.getName())) continue;
            return project;
        }
        return null;
    }

    @Nonnull
    public List<Project> getProjects() {
        return new ArrayList<Project>(this.projects.values());
    }

    @Nonnull
    public List<Project> getProjectObjects() {
        return this.getProjects();
    }

    public long getProjectCount() throws DataAccessException {
        return this.projects.size();
    }

    public Collection<ProjectCategory> getAllProjectCategories() {
        return this.projectCategories.values();
    }

    public ProjectCategory getProjectCategory(Long id) {
        throw new UnsupportedOperationException();
    }

    @Nullable
    public ProjectCategory getProjectCategoryObject(Long id) throws DataAccessException {
        throw new UnsupportedOperationException();
    }

    public void updateProjectCategory(ProjectCategory projectCategory) throws DataAccessException {
        throw new UnsupportedOperationException();
    }

    public Collection<Project> getProjectsFromProjectCategory(ProjectCategory projectCategory) throws DataAccessException {
        throw new UnsupportedOperationException();
    }

    public Collection<Project> getProjectObjectsFromProjectCategory(Long projectCategoryId) {
        throw new UnsupportedOperationException();
    }

    public Collection<Project> getProjectObjectsWithNoCategory() {
        throw new UnsupportedOperationException();
    }

    public ProjectCategory getProjectCategoryForProject(Project project) {
        throw new UnsupportedOperationException();
    }

    public void setProjectCategory(Project project, ProjectCategory category) {
        throw new UnsupportedOperationException();
    }

    public ProjectCategory createProjectCategory(String name, String description) {
        ProjectCategoryImpl projectCategory = new ProjectCategoryImpl(Long.valueOf(++this.projectCategoryCounter), name, description);
        this.projectCategories.put(projectCategory.getId(), (ProjectCategory)projectCategory);
        return projectCategory;
    }

    public void removeProjectCategory(Long id) {
        throw new UnsupportedOperationException();
    }

    public boolean isProjectCategoryUnique(String projectCategory) {
        throw new UnsupportedOperationException("Not implemented");
    }

    public List<Project> getProjectsLeadBy(ApplicationUser leadUser) {
        throw new UnsupportedOperationException("Not implemented");
    }

    public long getNextId(Project project) throws DataAccessException {
        throw new UnsupportedOperationException("not implemented");
    }

    public long getCurrentCounterForProject(Long id) {
        throw new UnsupportedOperationException();
    }

    public void setCurrentCounterForProject(Project project, long counter) {
        throw new UnsupportedOperationException();
    }

    public Project updateProjectType(ApplicationUser user, Project project, ProjectTypeKey newProjectType) {
        throw new UnsupportedOperationException();
    }

    public void refresh() {
        throw new UnsupportedOperationException();
    }
}

