/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.mock.issue;

import com.atlassian.jira.bc.project.component.ProjectComponent;
import com.atlassian.jira.issue.Issue;
import com.atlassian.jira.issue.IssueKey;
import com.atlassian.jira.issue.ModifiedValue;
import com.atlassian.jira.issue.MutableIssue;
import com.atlassian.jira.issue.fields.CustomField;
import com.atlassian.jira.issue.fields.renderer.IssueRenderContext;
import com.atlassian.jira.issue.issuetype.IssueType;
import com.atlassian.jira.issue.issuetype.IssueTypeImpl;
import com.atlassian.jira.issue.label.Label;
import com.atlassian.jira.issue.priority.Priority;
import com.atlassian.jira.issue.resolution.Resolution;
import com.atlassian.jira.issue.resolution.ResolutionImpl;
import com.atlassian.jira.issue.status.Status;
import com.atlassian.jira.issue.status.StatusImpl;
import com.atlassian.jira.mock.ofbiz.MockGenericValue;
import com.atlassian.jira.project.Project;
import com.atlassian.jira.project.ProjectImpl;
import com.atlassian.jira.user.ApplicationUser;
import com.atlassian.jira.user.ApplicationUsers;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import org.ofbiz.core.entity.GenericValue;

public class MockIssue
implements MutableIssue {
    private Long id;
    private Long projectId;
    private String key;
    private String issueTypeId;
    private String summary;
    private String description;
    private String environment;
    private String reporterId;
    private String creatorId;
    private Timestamp created;
    private Timestamp updated;
    private Timestamp dueDate;
    private Long securityLevelId;
    private String priorityId;
    private String resolutionId;
    private String statusId;
    private Long votes;
    private Long watches;
    private Long originalEstimate;
    private Long estimate;
    private Long workflowId;
    private Long parentId;
    private GenericValue genericValue;
    private Set<Label> labels = new LinkedHashSet<Label>();
    private Map<String, ModifiedValue> modifiedFields;
    private GenericValue project;
    private IssueType issueType;
    private Resolution resolution;
    private IssueType issueTypeObject;
    private ApplicationUser assignee;
    private Collection<ProjectComponent> components;
    private ApplicationUser reporter;
    private ApplicationUser creator;
    private Collection affectedVersions;
    private Resolution resolutionObject;
    private Collection fixVersions;
    private GenericValue securityLevel;
    private Priority priority;
    private Status status;
    private Long timeSpent;
    private Status statusObject;
    private Collection<Issue> subTaskObjects = new ArrayList<Issue>();
    private Timestamp resolutionDate;
    private boolean stored;
    private Project projectObject;
    private Map<String, Object> externalFields;
    private Long number;
    private Issue parentObject;
    private boolean parentObjectSet = false;
    private boolean subtask = false;

    public MockIssue() {
        this.modifiedFields = new HashMap<String, ModifiedValue>();
        this.externalFields = new HashMap<String, Object>();
        long now = System.currentTimeMillis();
        this.created = new Timestamp(now);
        this.updated = new Timestamp(now);
        this.dueDate = new Timestamp(now);
        this.resolutionDate = new Timestamp(now);
    }

    public MockIssue(Long id) {
        this(id, null);
    }

    public MockIssue(long id) {
        this(new Long(id), null);
    }

    public MockIssue(int id, String key) {
        this(new Long(id), null);
        this.setKey(key);
    }

    public MockIssue(int id, String key, boolean subtask) {
        this(new Long(id), null);
        this.setKey(key);
        this.subtask = subtask;
    }

    public MockIssue(Long id, Long now) {
        this.id = id;
        if (now != null) {
            this.created = new Timestamp(now);
            this.updated = new Timestamp(now);
            this.dueDate = new Timestamp(now);
        }
        this.modifiedFields = new HashMap<String, ModifiedValue>();
        this.externalFields = new HashMap<String, Object>();
    }

    public MockIssue(GenericValue gv) {
        this.setGenericValue(gv);
    }

    public Long getId() {
        return this.id;
    }

    public GenericValue getProject() {
        return this.project;
    }

    public Project getProjectObject() {
        if (this.projectObject == null && this.projectId != null) {
            return new ProjectImpl((GenericValue)new MockGenericValue("project", this.projectId));
        }
        return this.projectObject;
    }

    public void setProjectObject(Project projectObject) {
        this.projectObject = projectObject;
        if (projectObject != null) {
            this.project = projectObject.getGenericValue();
            this.projectId = projectObject.getId();
        } else {
            this.project = null;
            this.projectId = null;
        }
    }

    public void setProject(GenericValue project) {
        this.project = project;
        this.projectObject = project != null ? new ProjectImpl(project) : null;
    }

    public IssueType getIssueType() {
        return this.issueType;
    }

    public IssueType getIssueTypeObject() {
        return this.issueTypeObject;
    }

    public void setIssueType(GenericValue issueType) {
        this.setIssueType((IssueType)new IssueTypeImpl(issueType, null, null, null, null));
    }

    public void setIssueType(IssueType issueType) {
        this.issueType = issueType;
    }

    public void setIssueTypeId(String issueTypeId) {
        this.issueTypeId = issueTypeId;
    }

    public String getSummary() {
        return this.summary;
    }

    public void setSummary(String summary) {
        this.summary = summary;
    }

    public ApplicationUser getAssigneeUser() {
        return this.assignee;
    }

    public ApplicationUser getAssignee() {
        return this.assignee;
    }

    public String getAssigneeId() {
        return this.assignee != null ? this.assignee.getKey() : null;
    }

    public void setAssignee(ApplicationUser assignee) {
        this.assignee = assignee;
    }

    public void setComponent(Collection<ProjectComponent> components) {
        if (components == null) {
            components = Collections.emptyList();
        }
        ArrayList<GenericValue> gvList = new ArrayList<GenericValue>(components.size());
        for (ProjectComponent component : components) {
            gvList.add(component.getGenericValue());
        }
        this.components = components;
    }

    public Collection<ProjectComponent> getComponents() {
        return this.components;
    }

    public Collection<ProjectComponent> getComponentObjects() {
        return this.components;
    }

    public void setAssigneeId(String assigneeId) {
        this.assignee = ApplicationUsers.byKey((String)assigneeId);
        if (this.assignee == null && assigneeId != null) {
            String msg = String.format("Cannot find user for a key '%s'. Please mock UserManager#getUserByKey(\"%s\")", assigneeId, assigneeId);
            throw new NullPointerException(msg);
        }
    }

    public ApplicationUser getReporterUser() {
        return this.reporter;
    }

    public ApplicationUser getReporter() {
        return this.reporter;
    }

    public String getReporterId() {
        return this.reporterId;
    }

    public ApplicationUser getCreator() {
        return this.creator;
    }

    public String getCreatorId() {
        String key = ApplicationUsers.getKeyFor((ApplicationUser)this.creator);
        if (key == null && this.creator != null) {
            String msg = String.format("Cannot find key for creator. Please mock UserKeyService#getKeyForUsername(\"%s\")", this.creator.getName());
            throw new NullPointerException(msg);
        }
        return key;
    }

    public void setCreatorId(String creatorId) {
        this.creator = ApplicationUsers.byKey((String)creatorId);
        if (this.creator == null && creatorId != null) {
            String msg = String.format("Cannot find user for a key '%s'. Please mock UserManager#getUserByKey(\"%s\")", creatorId, creatorId);
            throw new NullPointerException(msg);
        }
    }

    public void setReporter(ApplicationUser reporter) {
        this.reporter = reporter;
    }

    public void setReporterId(String reporterId) {
        this.reporterId = reporterId;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public String getEnvironment() {
        return this.environment;
    }

    public void setEnvironment(String environment) {
        this.environment = environment;
    }

    public Collection getAffectedVersions() {
        return this.affectedVersions;
    }

    public Collection getFixVersions() {
        return this.fixVersions;
    }

    public Timestamp getDueDate() {
        return this.dueDate;
    }

    public GenericValue getSecurityLevel() {
        return null;
    }

    public String getIssueTypeId() {
        return this.issueTypeId;
    }

    public String getPriorityId() {
        return this.priorityId;
    }

    public Long getProjectId() {
        return this.projectId;
    }

    public String getResolutionId() {
        return this.resolutionId;
    }

    public Long getSecurityLevelId() {
        return this.securityLevelId;
    }

    public Priority getPriority() {
        return null;
    }

    public Priority getPriorityObject() {
        return null;
    }

    public String getStatusId() {
        return this.statusId;
    }

    public void setAffectedVersions(Collection affectedVersions) {
        this.affectedVersions = affectedVersions;
    }

    public void setFixVersions(Collection fixVersions) {
        this.fixVersions = fixVersions;
    }

    public void setDueDate(Timestamp dueDate) {
        this.dueDate = dueDate;
    }

    public void setSecurityLevel(GenericValue securityLevel) {
        this.securityLevel = securityLevel;
    }

    public void setPriority(Priority priority) {
        this.priority = priority;
    }

    public void setPriorityObject(Priority priority) {
        this.setPriority(priority);
    }

    public void setId(Long id) {
        this.id = id;
    }

    public void setIssueTypeObject(IssueType issueTypeObject) {
        this.issueTypeObject = issueTypeObject;
    }

    public void setProjectId(Long projectId) {
        this.projectId = projectId;
    }

    public void setSecurityLevelId(Long securityLevelId) {
        this.securityLevelId = securityLevelId;
    }

    public void setPriorityId(String priorityId) {
        this.priorityId = priorityId;
    }

    public Resolution getResolution() {
        return this.resolution;
    }

    public void setResolutionObject(Resolution resolutionObject) {
        this.resolutionObject = resolutionObject;
    }

    public Resolution getResolutionObject() {
        return this.resolutionObject;
    }

    public void setResolution(GenericValue resolution) {
        this.resolution = new ResolutionImpl(resolution, null, null, null);
    }

    public void setResolution(Resolution resolution) {
        this.resolution = resolution;
    }

    public String getKey() {
        return this.key;
    }

    public void setKey(String key) {
        this.key = key;
        if (key == null) {
            this.number = null;
        } else {
            IssueKey issueKey = IssueKey.from((String)key);
            this.number = issueKey.getIssueNumber();
        }
    }

    public void setNumber(Long number) {
        this.number = number;
    }

    public Long getNumber() {
        return this.number;
    }

    public Long getVotes() {
        return this.votes;
    }

    public void setVotes(Long votes) {
        this.votes = votes;
    }

    public Long getWatches() {
        return this.watches;
    }

    public void setWatches(Long watches) {
        this.watches = watches;
    }

    public Timestamp getCreated() {
        return this.created;
    }

    public void setCreated(Timestamp created) {
        this.created = created;
    }

    public Timestamp getUpdated() {
        return this.updated;
    }

    public Timestamp getResolutionDate() {
        return this.resolutionDate;
    }

    public void setResolutionDate(Timestamp resolutionDate) {
        this.resolutionDate = resolutionDate;
    }

    public void setUpdated(Timestamp updated) {
        this.updated = updated;
    }

    public Long getWorkflowId() {
        return this.workflowId;
    }

    public Object getCustomFieldValue(CustomField customField) {
        return null;
    }

    public Status getStatus() {
        return this.status;
    }

    public Status getStatusObject() {
        return this.statusObject;
    }

    public void setWorkflowId(Long workflowId) {
        this.workflowId = workflowId;
    }

    public void setStatusId(String statusId) {
        this.statusId = statusId;
    }

    public Map<String, ModifiedValue> getModifiedFields() {
        return this.modifiedFields;
    }

    public void setParentObject(Issue parentIssue) {
        this.parentObject = parentIssue;
        this.parentObjectSet = true;
    }

    public void setModifiedFields(Map modifiedFields) {
        this.modifiedFields = modifiedFields;
    }

    public void resetModifiedFields() {
        this.modifiedFields.clear();
    }

    public boolean isSubTask() {
        return this.subtask;
    }

    public Long getParentId() {
        return this.parentId;
    }

    public void setParentId(Long parentId) {
        this.parentId = parentId;
    }

    public boolean isCreated() {
        throw new UnsupportedOperationException("Not implemented.");
    }

    public GenericValue getParent() {
        throw new UnsupportedOperationException("Not implemented.");
    }

    public Issue getParentObject() {
        if (this.parentObjectSet) {
            return this.parentObject;
        }
        return new MockIssue(this.getParentId());
    }

    public Collection<GenericValue> getSubTasks() {
        throw new UnsupportedOperationException("Not implemented.");
    }

    public Collection<Issue> getSubTaskObjects() {
        return this.subTaskObjects;
    }

    public String getString(String name) {
        throw new UnsupportedOperationException("Not implemented.");
    }

    public Timestamp getTimestamp(String name) {
        throw new UnsupportedOperationException("Not implemented.");
    }

    public Long getLong(String name) {
        throw new UnsupportedOperationException("Not implemented.");
    }

    public GenericValue getGenericValue() {
        if (this.genericValue == null) {
            return this.getHackedGVThatReturnsId();
        }
        return this.genericValue;
    }

    protected GenericValue getHackedGVThatReturnsId() {
        MockGenericValue gv = new MockGenericValue("Issue");
        gv.set("id", this.getId());
        gv.set("issuekey", this.getId());
        gv.set("updated", this.getUpdated());
        if (this.getSecurityLevelId() != null) {
            gv.set("security", this.getSecurityLevelId());
        }
        return gv;
    }

    public void setGenericValue(GenericValue genericValue) {
        this.genericValue = genericValue;
        this.setId(genericValue.getLong("id"));
        this.setKey(genericValue.getString("key"));
        this.setProjectId(genericValue.getLong("project"));
        this.setSummary(genericValue.getString("summary"));
        this.setDescription(genericValue.getString("description"));
        this.setOriginalEstimate(genericValue.getLong("timeoriginalestimate"));
        this.setEstimate(genericValue.getLong("timeestimate"));
        this.setTimeSpent(genericValue.getLong("timespent"));
        this.setUpdated(genericValue.getTimestamp("updated"));
        this.setIssueTypeId(genericValue.getString("type"));
        this.setEnvironment(genericValue.getString("environment"));
        this.setAssigneeId(genericValue.getString("assignee"));
        this.setReporterId(genericValue.getString("reporter"));
        this.setCreatorId(genericValue.getString("creator"));
        this.setDueDate(genericValue.getTimestamp("duedate"));
        this.setSecurityLevelId(genericValue.getLong("security"));
        this.setPriorityId(genericValue.getString("priority"));
        this.setStatusId(genericValue.getString("status"));
        this.setResolutionId(genericValue.getString("resolution"));
        this.setCreated(genericValue.getTimestamp("created"));
        this.setResolutionDate(genericValue.getTimestamp("resolutiondate"));
        this.setVotes(genericValue.getLong("votes"));
        this.setWatches(genericValue.getLong("watches"));
        this.setWorkflowId(genericValue.getLong("workflowId"));
    }

    public void store() {
        this.stored = true;
    }

    public boolean isStored() {
        return this.stored;
    }

    public void setResolutionId(String resolutionId) {
        this.resolutionId = resolutionId;
    }

    public boolean isEditable() {
        return true;
    }

    public IssueRenderContext getIssueRenderContext() {
        throw new UnsupportedOperationException("Not implemented");
    }

    public Collection getAttachments() {
        throw new UnsupportedOperationException("Not implemented");
    }

    public void setCustomFieldValue(CustomField customField, Object value) {
    }

    public void setExternalFieldValue(String fieldId, Object value) {
        this.setExternalFieldValue(fieldId, null, value);
    }

    public void setExternalFieldValue(String fieldId, Object oldValue, Object newValue) {
        ModifiedValue modifiedValue = new ModifiedValue(oldValue, newValue);
        this.externalFields.put(fieldId, newValue);
        this.modifiedFields.put(fieldId, modifiedValue);
    }

    public void setStatus(GenericValue status) {
        this.status = new StatusImpl(status, null, null, null, null);
    }

    public void setStatus(Status status) {
        this.status = status;
    }

    public void setStatusObject(Status status) {
        this.status = status;
    }

    public void setTimeSpent(Long timespent) {
        this.timeSpent = timespent;
    }

    public Long getEstimate() {
        return this.estimate;
    }

    public Long getTimeSpent() {
        return this.timeSpent;
    }

    public void setLabels(Set<Label> labels) {
        this.labels = new LinkedHashSet<Label>(labels);
    }

    public Set<Label> getLabels() {
        return this.labels;
    }

    public Object getExternalFieldValue(String fieldId) {
        return this.externalFields.get(fieldId);
    }

    public Long getOriginalEstimate() {
        return this.originalEstimate;
    }

    public void setEstimate(Long estimate) {
        this.estimate = estimate;
    }

    public void setOriginalEstimate(Long originalEstimate) {
        this.originalEstimate = originalEstimate;
    }

    public void setSubTaskObjects(Collection subTaskObjects) {
        this.subTaskObjects = subTaskObjects;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        MockIssue issue = (MockIssue)o;
        if (this.affectedVersions != null ? !this.affectedVersions.equals(issue.affectedVersions) : issue.affectedVersions != null) {
            return false;
        }
        if (this.assignee != null ? !this.assignee.equals((Object)issue.assignee) : issue.assignee != null) {
            return false;
        }
        if (this.components != null ? !this.components.equals(issue.components) : issue.components != null) {
            return false;
        }
        if (this.created != null ? !this.created.equals(issue.created) : issue.created != null) {
            return false;
        }
        if (this.description != null ? !this.description.equals(issue.description) : issue.description != null) {
            return false;
        }
        if (this.dueDate != null ? !this.dueDate.equals(issue.dueDate) : issue.dueDate != null) {
            return false;
        }
        if (this.environment != null ? !this.environment.equals(issue.environment) : issue.environment != null) {
            return false;
        }
        if (this.estimate != null ? !this.estimate.equals(issue.estimate) : issue.estimate != null) {
            return false;
        }
        if (this.fixVersions != null ? !this.fixVersions.equals(issue.fixVersions) : issue.fixVersions != null) {
            return false;
        }
        if (this.genericValue != null ? !this.genericValue.equals((Object)issue.genericValue) : issue.genericValue != null) {
            return false;
        }
        if (!this.id.equals(issue.id)) {
            return false;
        }
        if (this.issueType != null ? !this.issueType.equals(issue.issueType) : issue.issueType != null) {
            return false;
        }
        if (this.issueTypeId != null ? !this.issueTypeId.equals(issue.issueTypeId) : issue.issueTypeId != null) {
            return false;
        }
        if (this.issueTypeObject != null ? !this.issueTypeObject.equals(issue.issueTypeObject) : issue.issueTypeObject != null) {
            return false;
        }
        if (this.key != null ? !this.key.equals(issue.key) : issue.key != null) {
            return false;
        }
        if (this.originalEstimate != null ? !this.originalEstimate.equals(issue.originalEstimate) : issue.originalEstimate != null) {
            return false;
        }
        if (this.parentId != null ? !this.parentId.equals(issue.parentId) : issue.parentId != null) {
            return false;
        }
        if (this.priority != null ? !this.priority.equals(issue.priority) : issue.priority != null) {
            return false;
        }
        if (this.priorityId != null ? !this.priorityId.equals(issue.priorityId) : issue.priorityId != null) {
            return false;
        }
        if (this.project != null ? !this.project.equals((Object)issue.project) : issue.project != null) {
            return false;
        }
        if (this.projectId != null ? !this.projectId.equals(issue.projectId) : issue.projectId != null) {
            return false;
        }
        if (this.reporter != null ? !this.reporter.equals((Object)issue.reporter) : issue.reporter != null) {
            return false;
        }
        if (this.reporterId != null ? !this.reporterId.equals(issue.reporterId) : issue.reporterId != null) {
            return false;
        }
        if (this.resolution != null ? !this.resolution.equals(issue.resolution) : issue.resolution != null) {
            return false;
        }
        if (this.resolutionId != null ? !this.resolutionId.equals(issue.resolutionId) : issue.resolutionId != null) {
            return false;
        }
        if (this.resolutionObject != null ? !this.resolutionObject.equals(issue.resolutionObject) : issue.resolutionObject != null) {
            return false;
        }
        if (this.securityLevel != null ? !this.securityLevel.equals((Object)issue.securityLevel) : issue.securityLevel != null) {
            return false;
        }
        if (this.securityLevelId != null ? !this.securityLevelId.equals(issue.securityLevelId) : issue.securityLevelId != null) {
            return false;
        }
        if (this.status != null ? !this.status.equals(issue.status) : issue.status != null) {
            return false;
        }
        if (this.statusId != null ? !this.statusId.equals(issue.statusId) : issue.statusId != null) {
            return false;
        }
        if (this.statusObject != null ? !this.statusObject.equals(issue.statusObject) : issue.statusObject != null) {
            return false;
        }
        if (this.summary != null ? !this.summary.equals(issue.summary) : issue.summary != null) {
            return false;
        }
        if (this.timeSpent != null ? !this.timeSpent.equals(issue.timeSpent) : issue.timeSpent != null) {
            return false;
        }
        if (this.updated != null ? !this.updated.equals(issue.updated) : issue.updated != null) {
            return false;
        }
        if (this.votes != null ? !this.votes.equals(issue.votes) : issue.votes != null) {
            return false;
        }
        if (this.watches != null ? !this.watches.equals(issue.watches) : issue.watches != null) {
            return false;
        }
        if (this.labels != null ? !this.labels.equals(issue.labels) : issue.labels != null) {
            return false;
        }
        if (this.workflowId != null ? !this.workflowId.equals(issue.workflowId) : issue.workflowId != null) {
            return false;
        }
        return !(this.projectObject != null ? !this.projectObject.equals(issue.projectObject) : issue.projectObject != null);
    }

    public String toString() {
        return String.format("Mock Issue %d", this.id);
    }
}

