/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.mock.issue.index;

import com.atlassian.jira.index.Index;
import com.atlassian.jira.issue.Issue;
import com.atlassian.jira.issue.comments.Comment;
import com.atlassian.jira.issue.index.IndexDirectoryFactory;
import com.atlassian.jira.issue.index.IssueIndexer;
import com.atlassian.jira.issue.index.IssueIndexingParams;
import com.atlassian.jira.issue.worklog.Worklog;
import com.atlassian.jira.task.context.Context;
import com.atlassian.jira.util.collect.EnclosedIterable;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import javax.annotation.Nonnull;
import net.jcip.annotations.ThreadSafe;
import org.apache.lucene.search.IndexSearcher;

@ThreadSafe
public class MockIssueIndexer
implements IssueIndexer {
    public final int indexWorkTime;
    public final int optimizationWorkTime;
    public final Collection<Issue> indexedIssues = new ConcurrentLinkedQueue<Issue>();
    public final Collection<Issue> reIndexedIssues = new ConcurrentLinkedQueue<Issue>();
    public final AtomicInteger optimizations = new AtomicInteger();

    public MockIssueIndexer() {
        this(1000, 2000);
    }

    public MockIssueIndexer(int indexSleepTime, int optimizationSleepTime) {
        this.indexWorkTime = indexSleepTime;
        this.optimizationWorkTime = optimizationSleepTime;
    }

    public Index.Result indexIssues(@Nonnull EnclosedIterable<Issue> issues, @Nonnull Context context) {
        this.indexedIssues.addAll(EnclosedIterable.Functions.toList(issues));
        return new MockResult(this.indexWorkTime);
    }

    public Index.Result indexIssues(@Nonnull EnclosedIterable<Issue> issues, @Nonnull Context context, @Nonnull IssueIndexingParams issueIndexingParams) {
        return null;
    }

    public Index.Result deindexIssues(@Nonnull EnclosedIterable<Issue> issues, @Nonnull Context context) {
        return null;
    }

    public Index.Result reindexIssues(@Nonnull EnclosedIterable<Issue> issues, @Nonnull Context context, IssueIndexingParams issueIndexingParams, boolean conditionalUpdate) {
        this.reIndexedIssues.addAll(EnclosedIterable.Functions.toList(issues));
        return new MockResult(this.indexWorkTime);
    }

    public Index.Result reindexIssues(@Nonnull EnclosedIterable<Issue> issues, @Nonnull Context context, boolean reIndexComments, boolean reIndexChangeHistory, boolean conditionalUpdate) {
        return null;
    }

    public Index.Result indexIssuesBatchMode(@Nonnull EnclosedIterable<Issue> issues, @Nonnull Context context) {
        return null;
    }

    public Index.Result indexIssuesBatchMode(@Nonnull EnclosedIterable<Issue> issues, @Nonnull Context context, @Nonnull IssueIndexingParams issueIndexingParams) {
        return null;
    }

    public Index.Result reindexComments(@Nonnull Collection<Comment> comments, @Nonnull Context context) {
        return null;
    }

    public Index.Result reindexWorklogs(@Nonnull Collection<Worklog> worklogs, @Nonnull Context context) {
        return null;
    }

    public Index.Result optimize() {
        this.optimizations.incrementAndGet();
        return new MockResult(this.optimizationWorkTime);
    }

    public void deleteIndexes() {
    }

    public void deleteIndexes(IssueIndexingParams issueIndexingParams) {
    }

    public void shutdown() {
    }

    public IndexSearcher openEntitySearcher(IndexDirectoryFactory.Name index) {
        return null;
    }

    public List<String> getIndexPaths() {
        return null;
    }

    public String getIndexRootPath() {
        return null;
    }

    private static final class MockResult
    implements Index.Result {
        private final int workTime;
        private volatile boolean done = false;

        public MockResult(int sleepTime) {
            this.workTime = sleepTime;
        }

        public void await() {
            this.simulateWork();
        }

        public boolean await(long timeout, TimeUnit unit) {
            if (unit.toMillis(timeout) > (long)this.workTime) {
                this.simulateWork();
                return true;
            }
            try {
                unit.sleep(timeout);
                return false;
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
                throw new RuntimeException(e);
            }
        }

        public boolean isDone() {
            return this.done;
        }

        private void simulateWork() {
            try {
                Thread.sleep(this.workTime);
                this.done = true;
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
                throw new RuntimeException(e);
            }
        }
    }
}

